/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.repository;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.model.Model;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.dependency.GetMavenRepoURL;
import org.maxxq.maven.dependency.GetVersionsURL;
import org.maxxq.maven.dependency.IModelIO;
import org.maxxq.maven.dependency.ModelIO;
import org.maxxq.maven.model.MavenModel;
import org.maxxq.maven.repository.IRepository;
import org.maxxq.maven.repository.RepositoryException;

public class LocalFileRepository
implements IRepository {
    private static final Logger LOGGER = LogManager.getLogger(LocalFileRepository.class);
    private final Function<GAV, String> getMavenRepoPath;
    private final BiFunction<String, String, String> getMavenMetaRepoPath;
    private final IModelIO modelIO;

    public LocalFileRepository(Path basePath) {
        this(basePath, new ModelIO());
    }

    LocalFileRepository(Path basePath, IModelIO modelIO) {
        this.getMavenRepoPath = new GetMavenRepoURL(basePath.toString());
        this.getMavenMetaRepoPath = new GetVersionsURL(basePath.toString());
        this.modelIO = modelIO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Model> readPom(GAV gav) {
        Optional<Model> optional;
        Path path = Paths.get(this.getMavenRepoPath.apply(gav), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) return Optional.empty();
        BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        LOGGER.trace("Reading pom from '{}'", (Object)path.toFile());
        FileInputStream input = new FileInputStream(path.toFile());
        try {
            optional = Optional.of(new MavenModel(this.modelIO.getModelFromInputStream(input), new Date(attributes.lastModifiedTime().toMillis())));
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RepositoryException("Could not read from path: '" + path + "'", e);
            }
        }
        input.close();
        return optional;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public GAV store(Model model) {
        GAV gav = GAV.fromModel(model);
        Path path = Paths.get(this.getMavenRepoPath.apply(gav), new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            LOGGER.trace("Writing pom to '{}'", (Object)path.toFile());
            try (FileOutputStream output = new FileOutputStream(path.toFile());){
                this.modelIO.writeModelToStream(model, output);
            }
            if (model instanceof MavenModel) {
                Files.setLastModifiedTime(path, FileTime.fromMillis(((MavenModel)model).getCreationDate().getTime()));
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Could not write to '" + path + "'", e);
        }
        return gav;
    }

    @Override
    public Optional<Metadata> getMetaData(String groupId, String artifactId) {
        block7: {
            Optional<Metadata> optional;
            Path path = Paths.get(this.getMavenMetaRepoPath.apply(groupId, artifactId), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) break block7;
            LOGGER.trace("Reading metadata from '{}'", (Object)path.toFile());
            FileInputStream input = new FileInputStream(path.toFile());
            try {
                optional = Optional.of(this.modelIO.getMetaDataFromString(input));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RepositoryException("Could not read/write to path: '" + path + "'", e);
                }
            }
            input.close();
            return optional;
        }
        return Optional.empty();
    }
}

