/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.dependency;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.maxxq.maven.dependency.IDependencyFilter;

public class DependencyFilter
implements IDependencyFilter {
    private boolean keepOptional = false;
    private boolean keepTest = false;
    private boolean keepTestRootOnly = true;
    private boolean keepCompile = true;
    private boolean keepRuntime = true;
    private boolean keepProvided = false;

    public boolean isKeepOptional() {
        return this.keepOptional;
    }

    public void setKeepOptional(boolean keepOptional) {
        this.keepOptional = keepOptional;
    }

    public boolean isKeepTest() {
        return this.keepTest;
    }

    public void setKeepTest(boolean keepTest) {
        this.keepTest = keepTest;
    }

    public boolean isKeepCompile() {
        return this.keepCompile;
    }

    public void setKeepCompile(boolean keepCompile) {
        this.keepCompile = keepCompile;
    }

    public boolean isKeepRuntime() {
        return this.keepRuntime;
    }

    public void setKeepRuntime(boolean keepRuntime) {
        this.keepRuntime = keepRuntime;
    }

    public boolean isKeepProvided() {
        return this.keepProvided;
    }

    public void setKeepProvided(boolean keepProvided) {
        this.keepProvided = keepProvided;
    }

    @Override
    public boolean keepDependency(Dependency dependency, int depth) {
        if (StringUtils.isEmpty((CharSequence)dependency.getScope())) {
            return true;
        }
        if (this.keepOptional && dependency.isOptional()) {
            return true;
        }
        if (this.keepCompile && "compile".equals(dependency.getScope())) {
            return true;
        }
        if (this.keepTest && "test".equals(dependency.getScope())) {
            return true;
        }
        if (this.keepTestRootOnly && "test".equals(dependency.getScope()) && this.isRootPOM(depth)) {
            return true;
        }
        if (this.keepRuntime && "runtime".equals(dependency.getScope())) {
            return true;
        }
        return this.keepProvided && "provided".equals(dependency.getScope());
    }

    private boolean isRootPOM(int depth) {
        return depth == 0;
    }
}

