/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.dependency;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.maxxq.maven.dependency.ComparableDependency;
import org.maxxq.maven.dependency.DepencyResolvingException;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.dependency.IDependencyFilter;
import org.maxxq.maven.dependency.IDependencyResolver;
import org.maxxq.maven.dependency.IPomStreamProvider;
import org.maxxq.maven.dependency.ModelIO;
import org.maxxq.maven.dependency.ResolveDependenciesWorker;
import org.maxxq.maven.repository.IRepository;

public class ResolveDependencies
implements IDependencyResolver {
    private final IRepository repository;
    private boolean ignoreIconsistencies = false;
    private IPomStreamProvider pomStreamProvider;
    private IDependencyFilter dependencyFilter;

    public ResolveDependencies(IRepository repository) {
        this.repository = repository;
    }

    public boolean isIgnoreIconsistencies() {
        return this.ignoreIconsistencies;
    }

    public ResolveDependencies setIgnoreIconsistencies(boolean ignoreIconsistencies) {
        this.ignoreIconsistencies = ignoreIconsistencies;
        return this;
    }

    public IPomStreamProvider getPomStreamProvider() {
        return this.pomStreamProvider;
    }

    public ResolveDependencies setPomStreamProvider(IPomStreamProvider pomStreamProvider) {
        this.pomStreamProvider = pomStreamProvider;
        return this;
    }

    @Override
    public List<GAV> storeMultiModule(InputStream inputStream, String relativePathOfGivenPomStream) {
        return this.storeMultiModule(new ModelIO().getModelFromInputStream(inputStream), relativePathOfGivenPomStream);
    }

    @Override
    public List<GAV> storeMultiModule(Model model, String relativePathOfGivenPomModel) {
        ArrayList<GAV> gavs = new ArrayList<GAV>();
        GAV gav = this.repository.store(model);
        gavs.add(gav);
        if (this.pomStreamProvider != null && model.getModules() != null) {
            gavs.addAll(this.followAndGetGavOfModules(model, relativePathOfGivenPomModel));
        }
        return gavs;
    }

    private Collection<GAV> followAndGetGavOfModules(Model model, String relativePathOfGivenPomModel) {
        return model.getModules().stream().map(module -> relativePathOfGivenPomModel + "/" + module).map(modulePath -> new PomStreamAndRelativeLocation((String)modulePath, this.pomStreamProvider.loadPomFromRelativeLocation((String)modulePath))).filter(pomStreamAndRelativeLocation -> pomStreamAndRelativeLocation.isPresent()).flatMap(pomStreamAndRelativeLocation -> this.storeMultiModule(pomStreamAndRelativeLocation.getPomStream(), pomStreamAndRelativeLocation.getRelativeLocation()).stream()).collect(Collectors.toList());
    }

    @Override
    public GAV store(Model model) {
        return this.repository.store(model);
    }

    @Override
    public GAV store(InputStream inputStream) {
        return this.store(new ModelIO().getModelFromInputStream(inputStream));
    }

    @Override
    public Set<Dependency> getDependencies(InputStream ... pomStreams) {
        Set gavs = Arrays.stream(pomStreams).map(pomStream -> this.store((InputStream)pomStream)).collect(Collectors.toSet());
        return this.getDependencies(gavs.stream());
    }

    @Override
    public Set<Dependency> getDependencies(boolean excludeCorrespondingGavs, InputStream ... pomStreams) {
        Set gavs = Arrays.stream(pomStreams).map(pomStream -> this.store((InputStream)pomStream)).collect(Collectors.toSet());
        return this.getDependencies(gavs.stream(), excludeCorrespondingGavs ? gavs : new ArrayList());
    }

    @Override
    public Set<Dependency> getDependencies(InputStream pomStream) {
        GAV gav = this.store(pomStream);
        return this.getDependencies(gav);
    }

    @Override
    public Set<Dependency> getDependencies(Collection<GAV> gavs) {
        return this.getDependencies(gavs.stream());
    }

    @Override
    public Set<Dependency> getDependencies(Stream<GAV> gavs) {
        return this.removeDuplicates(gavs.flatMap(gav -> this.getDependencies((GAV)gav).stream()).collect(Collectors.toSet()));
    }

    private Set<Dependency> removeDuplicates(Set<Dependency> dependencies) {
        return dependencies.stream().map(dependency -> new ComparableDependency((Dependency)dependency)).distinct().map(dependency -> dependency.getDependency()).collect(Collectors.toSet());
    }

    @Override
    public Set<Dependency> getDependencies(Stream<GAV> gavs, Collection<GAV> gavsToExclude) {
        return gavs.flatMap(gav -> this.getDependencies((GAV)gav).stream()).filter(dependency -> !gavsToExclude.contains(GAV.fromDependency(dependency))).collect(Collectors.toSet());
    }

    @Override
    public Set<Dependency> getDependencies(GAV ... gavs) {
        return this.getDependencies(Arrays.stream(gavs));
    }

    @Override
    public Set<Dependency> getDependencies(GAV gav) {
        try {
            Optional<Model> model = this.repository.readPom(gav);
            if (!model.isPresent()) {
                return new LinkedHashSet<Dependency>();
            }
            return new ResolveDependenciesWorker(model.get(), this.repository, this.ignoreIconsistencies, this.dependencyFilter).get();
        }
        catch (DepencyResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DepencyResolvingException("Could not resolve dependencies", e);
        }
    }

    public ResolveDependencies setDependenyFilter(IDependencyFilter dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        return this;
    }

    private class PomStreamAndRelativeLocation {
        public String relativeLocation;
        public Optional<InputStream> pomStream;

        public PomStreamAndRelativeLocation(String relativeLocation, Optional<InputStream> pomStream) {
            this.relativeLocation = relativeLocation;
            this.pomStream = pomStream;
        }

        public boolean isPresent() {
            return this.pomStream.isPresent();
        }

        public InputStream getPomStream() {
            return this.pomStream.get();
        }

        public String getRelativeLocation() {
            return this.relativeLocation;
        }
    }
}

