/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.repository;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.model.Model;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.dependency.GetMavenRepoURL;
import org.maxxq.maven.dependency.GetVersionsURL;
import org.maxxq.maven.dependency.IModelIO;
import org.maxxq.maven.dependency.ModelIO;
import org.maxxq.maven.model.MavenModel;
import org.maxxq.maven.repository.IRepository;
import org.maxxq.maven.repository.RepositoryException;

public class FileCachingRepository
implements IRepository {
    private static final Logger LOGGER = LogManager.getLogger(FileCachingRepository.class);
    private final IRepository repository;
    private final Function<GAV, String> getMavenRepoPath;
    private final BiFunction<String, String, String> getMavenMetaRepoPath;
    private final IModelIO modelIO;

    public FileCachingRepository(Path basePath, IRepository repository) {
        this(repository, basePath, new ModelIO());
    }

    FileCachingRepository(IRepository repository, Path basePath, IModelIO modelIO) {
        this.repository = repository;
        this.getMavenRepoPath = new GetMavenRepoURL(basePath.toString());
        this.getMavenMetaRepoPath = new GetVersionsURL(basePath.toString());
        this.modelIO = modelIO;
    }

    @Override
    public Optional<Model> readPom(GAV gav) {
        Path path = Paths.get(this.getMavenRepoPath.apply(gav), new String[0]);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                LOGGER.trace("Reading pom from '{}'", (Object)path.toFile());
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                Throwable throwable = null;
                Object var5_10 = null;
                try (FileInputStream input = new FileInputStream(path.toFile());){
                    return Optional.of(new MavenModel(this.modelIO.getModelFromInputStream(input), new Date(attributes.lastModifiedTime().toMillis())));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Optional<Model> modelOptional = this.repository.readPom(gav);
            if (modelOptional.isPresent()) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                LOGGER.trace("Writing pom from '{}'", (Object)path.toFile());
                Throwable throwable = null;
                Object var5_12 = null;
                try (FileOutputStream output = new FileOutputStream(path.toFile());){
                    this.modelIO.writeModelToStream(modelOptional.get(), output);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                if (modelOptional.get() instanceof MavenModel) {
                    Files.setLastModifiedTime(path, FileTime.fromMillis(((MavenModel)modelOptional.get()).getCreationDate().getTime()));
                }
            }
            return modelOptional;
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read/write to path: '" + String.valueOf(path) + "'", e);
        }
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public GAV store(Model model) {
        throw new UnsupportedOperationException("Store not supported in this repository");
    }

    @Override
    public Optional<Metadata> getMetaData(String groupId, String artifactId) {
        Path path = Paths.get(this.getMavenMetaRepoPath.apply(groupId, artifactId), new String[0]);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                LOGGER.trace("Reading metadata from '{}'", (Object)path.toFile());
                Throwable throwable = null;
                Object var5_8 = null;
                try (FileInputStream input = new FileInputStream(path.toFile());){
                    return Optional.of(this.modelIO.getMetaDataFromString(input));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Optional<Metadata> metaOptional = this.repository.getMetaData(groupId, artifactId);
            if (metaOptional.isPresent()) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                LOGGER.trace("Writing metadata from '{}'", (Object)path.toFile());
                Throwable throwable = null;
                Object var6_13 = null;
                try (FileOutputStream output = new FileOutputStream(path.toFile());){
                    this.modelIO.writeMetadataToStream(metaOptional.get(), output);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            return metaOptional;
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read/write to path: '" + String.valueOf(path) + "'", e);
        }
    }
}

