/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.repository;

import java.util.Optional;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.maxxq.maven.repository.CallResponse;
import org.maxxq.maven.repository.IRemoteRepositoryAdapter;
import org.maxxq.maven.repository.IRemoteRepositoryRequestBuilder;
import org.maxxq.maven.repository.RepositoryException;

public class RemoteRepositoryAdapter
implements IRemoteRepositoryAdapter {
    private static final Logger LOGGER = LogManager.getLogger(RemoteRepositoryAdapter.class);
    private final IRemoteRepositoryRequestBuilder requestBuilder;
    private final OkHttpClient client = new OkHttpClient();

    public RemoteRepositoryAdapter(IRemoteRepositoryRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    @Override
    public Optional<CallResponse> call(String endPoint) {
        try {
            Request request = (Request)this.requestBuilder.apply(endPoint);
            Call call = this.client.newCall(request);
            Throwable throwable = null;
            Object var5_7 = null;
            try (Response response = call.execute();){
                if (response.code() != 404) {
                    if (response.code() != 200) {
                        throw new RepositoryException("Could not retrieve pom at endpoint '" + endPoint + "' http response code '" + response.code() + "'");
                    }
                    return Optional.of(new CallResponse(response.body().string(), response.headers()));
                }
                LOGGER.warn("no pom file found at: '{}' in remote repo", (Object)endPoint);
                return Optional.empty();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Error occured when calling endpoint: + '" + endPoint + "'", e);
        }
    }
}

