/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.repository;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.model.Model;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.dependency.GetMavenRepoURL;
import org.maxxq.maven.dependency.GetVersionsURL;
import org.maxxq.maven.dependency.IModelIO;
import org.maxxq.maven.dependency.ModelIO;
import org.maxxq.maven.repository.IRepository;
import org.maxxq.maven.repository.RepositoryException;

public class FileCachingRepository
implements IRepository {
    private static final Logger LOGGER = LogManager.getLogger(FileCachingRepository.class);
    private final IRepository repository;
    private final Function<GAV, String> getMavenRepoPath;
    private final BiFunction<String, String, String> getMavenMetaRepoPath;
    private final IModelIO modelIO;

    public FileCachingRepository(Path basePath, IRepository repository) {
        this(repository, basePath, new ModelIO());
    }

    FileCachingRepository(IRepository repository, Path basePath, IModelIO modelIO) {
        this.repository = repository;
        this.getMavenRepoPath = new GetMavenRepoURL(basePath.toString());
        this.getMavenMetaRepoPath = new GetVersionsURL(basePath.toString());
        this.modelIO = modelIO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Model> readPom(GAV gav) {
        Path path = Paths.get(this.getMavenRepoPath.apply(gav), new String[0]);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                LOGGER.trace("Reading pom from '{}'", (Object)path.toFile());
                try (FileInputStream input = new FileInputStream(path.toFile());){
                    Optional<Model> optional = Optional.of(this.modelIO.getModelFromInputStream(input));
                    return optional;
                }
            }
            Optional<Model> modelOptional = this.repository.readPom(gav);
            if (!modelOptional.isPresent()) return modelOptional;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            LOGGER.trace("Writing pom from '{}'", (Object)path.toFile());
            try (FileOutputStream output = new FileOutputStream(path.toFile());){
                this.modelIO.writeModelToStream(modelOptional.get(), output);
                return modelOptional;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read/write to path: '" + path + "'", e);
        }
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public GAV store(Model model) {
        throw new UnsupportedOperationException("Store not supported in this repository");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Metadata> getMetaData(String groupId, String artifactId) {
        Path path = Paths.get(this.getMavenMetaRepoPath.apply(groupId, artifactId), new String[0]);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                LOGGER.trace("Reading metadata from '{}'", (Object)path.toFile());
                try (FileInputStream input = new FileInputStream(path.toFile());){
                    Optional<Metadata> optional = Optional.of(this.modelIO.getMetaDataFromString(input));
                    return optional;
                }
            }
            Optional<Metadata> metaOptional = this.repository.getMetaData(groupId, artifactId);
            if (!metaOptional.isPresent()) return metaOptional;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            LOGGER.trace("Writing metadata from '{}'", (Object)path.toFile());
            try (FileOutputStream output = new FileOutputStream(path.toFile());){
                this.modelIO.writeMetadataToStream(metaOptional.get(), output);
                return metaOptional;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read/write to path: '" + path + "'", e);
        }
    }
}

