/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.model.Model;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.repository.IRepository;

public class LocalInMemoryRepository
implements IRepository {
    private final Map<GAV, Model> store = new HashMap<GAV, Model>();

    @Override
    public Optional<Model> readPom(GAV gav) {
        if (this.store.containsKey(gav)) {
            return Optional.of(this.store.get(gav));
        }
        return Optional.empty();
    }

    @Override
    public GAV store(Model model) {
        GAV gav = GAV.fromModel(model);
        this.store.put(gav, model);
        return gav;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public Optional<Metadata> getMetaData(String groupId, String artifactId) {
        return Optional.empty();
    }
}

