/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.gis;

import java.io.Serializable;
import org.mbari.scommons.gis.ArrayGrid;
import org.mbari.scommons.gis.FloatArrayGrid$;
import org.mbari.scommons.gis.Grid;
import org.mbari.scommons.gis.NumericGrid;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public class FloatArrayGrid<A, B>
extends ArrayGrid<A, B, Object>
implements NumericGrid<A, B, Object> {
    private final IndexedSeq<A> x;
    private final IndexedSeq<B> y;

    public static <A, B> float $lessinit$greater$default$3() {
        return FloatArrayGrid$.MODULE$.$lessinit$greater$default$3();
    }

    public FloatArrayGrid(IndexedSeq<A> x, IndexedSeq<B> y, float[][] z) {
        this.x = x;
        this.y = y;
        super(x, y, (Object[])z, ClassTag$.MODULE$.apply(Float.TYPE));
    }

    public FloatArrayGrid(IndexedSeq<A> x, IndexedSeq<B> y, float defaultValue) {
        this(x, y, FloatArrayGrid.FloatArrayGrid$superArg$1(x, y, defaultValue));
    }

    public <C> FloatArrayGrid<A, B> $plus(Grid<A, B, C> grid, Numeric<C> numeric) {
        Predef$.MODULE$.require(grid.x().size() == this.x.size(), FloatArrayGrid::$plus$$anonfun$1);
        Predef$.MODULE$.require(grid.y().size() == this.y.size(), FloatArrayGrid::$plus$$anonfun$2);
        FloatArrayGrid<A, B> newGrid = new FloatArrayGrid<A, B>(this.x, this.y, 0.0f);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.x.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.y.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> newGrid.update(i, j, BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat(this.z(i, j)) + numeric.toFloat(grid.apply(i, j)))))));
        return newGrid;
    }

    public <C> FloatArrayGrid<A, B> normalize(Grid<A, B, C> effort, Numeric<C> evidence$1) {
        Predef$.MODULE$.require(effort.x().size() == this.x.size(), FloatArrayGrid::normalize$$anonfun$1);
        Predef$.MODULE$.require(effort.y().size() == this.y.size(), FloatArrayGrid::normalize$$anonfun$2);
        FloatArrayGrid<A, B> normalizedEffort = FloatArrayGrid$.MODULE$.normalize(effort, evidence$1);
        FloatArrayGrid<A, B> normalizedGrid = new FloatArrayGrid<A, B>(this.x, this.y, 0.0f);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.x.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)xi -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.y.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)yi -> normalizedGrid.update(xi, yi, BoxesRunTime.boxToFloat((float)(!BoxesRunTime.equals(effort.apply(xi, yi), (Object)BoxesRunTime.boxToInteger((int)0)) ? BoxesRunTime.unboxToFloat(this.z(xi, yi)) / BoxesRunTime.unboxToFloat((Object)normalizedEffort.apply(xi, yi)) : Float.NaN)))));
        return FloatArrayGrid$.MODULE$.normalize(normalizedGrid, Numeric.FloatIsFractional$.MODULE$);
    }

    public FloatArrayGrid<A, B> normalize() {
        return FloatArrayGrid$.MODULE$.normalize(this, Numeric.FloatIsFractional$.MODULE$);
    }

    private static <A, B> float[][] FloatArrayGrid$superArg$1(IndexedSeq<A> x, IndexedSeq<B> y, float defaultValue) {
        return (float[][])Array$.MODULE$.tabulate(x.size(), y.size(), (Function2)(JFunction2.mcFII.sp & Serializable)(u, v) -> defaultValue, ClassTag$.MODULE$.apply(Float.TYPE));
    }

    private static final Object $plus$$anonfun$1() {
        return "Unable to add grid with different X dimensions";
    }

    private static final Object $plus$$anonfun$2() {
        return "Unable to add grid with different Y dimensions";
    }

    private static final Object normalize$$anonfun$1() {
        return "Unable to normalize grid with different X dimensions";
    }

    private static final Object normalize$$anonfun$2() {
        return "Unable to normalize grid with different Y dimensions";
    }
}

