/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.gis;

import java.io.File;
import java.io.Serializable;
import org.mbari.scommons.geometry.DoubleTriangle3D;
import org.mbari.scommons.geometry.Point3D;
import org.mbari.scommons.geometry.Point3D$;
import org.mbari.scommons.geometry.Triangle3D;
import org.mbari.scommons.geometry.Triangle3D$;
import org.mbari.scommons.gis.ASCGridReader$;
import org.mbari.scommons.gis.ASCGridWriter$;
import org.mbari.scommons.gis.ArrayGrid;
import org.mbari.scommons.gis.ArrayGrid$;
import org.mbari.scommons.gis.DoubleArrayGrid;
import org.mbari.scommons.gis.Grid;
import org.mbari.scommons.gis.MutableGrid;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class RugosityCalculator$
implements Serializable {
    public static final RugosityCalculator$ MODULE$ = new RugosityCalculator$();

    private RugosityCalculator$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RugosityCalculator$.class);
    }

    public ArrayGrid<Object, Object, Object> apply(Grid<Object, Object, Object> grid) {
        IndexedSeq<Object> x = grid.x();
        IndexedSeq<Object> y = grid.y();
        IndexedSeq dx = (IndexedSeq)((IndexedSeqOps)((IterableOps)x.init()).zip((IterableOnce)x.tail())).map((Function1 & Serializable)a -> package$.MODULE$.abs(a._1$mcD$sp() - a._2$mcD$sp()));
        IndexedSeq dy = (IndexedSeq)((IndexedSeqOps)((IterableOps)y.init()).zip((IterableOnce)y.tail())).map((Function1 & Serializable)a -> package$.MODULE$.abs(a._1$mcD$sp() - a._2$mcD$sp()));
        DoubleArrayGrid<Object, Object> rugosity = ArrayGrid$.MODULE$.apply(x, y, Double.NaN);
        Point3D[][] points = new Point3D[x.size()][y.size()];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), x.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), y.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            points$2[i$1][j] = Point3D$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x.apply(i)), BoxesRunTime.unboxToDouble((Object)y.apply(j)), BoxesRunTime.unboxToDouble(grid.apply(i, j)));
        }));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), x.size() - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), y.size() - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            Point3D p1 = points[i - 1][j - 1];
            Point3D p2 = points[i - 1][j];
            Point3D p3 = points[i - 1][j + 1];
            Point3D p4 = points[i][j - 1];
            Point3D p5 = points[i][j + 1];
            Point3D p6 = points[i + 1][j - 1];
            Point3D p7 = points[i + 1][j];
            Point3D p8 = points[i + 1][j + 1];
            Point3D center = points[i][j];
            DoubleTriangle3D t1 = Triangle3D$.MODULE$.apply(p1, p2, center);
            DoubleTriangle3D t2 = Triangle3D$.MODULE$.apply(p2, p3, center);
            DoubleTriangle3D t3 = Triangle3D$.MODULE$.apply(p1, p4, center);
            DoubleTriangle3D t4 = Triangle3D$.MODULE$.apply(p3, p5, center);
            DoubleTriangle3D t5 = Triangle3D$.MODULE$.apply(p4, p6, center);
            DoubleTriangle3D t6 = Triangle3D$.MODULE$.apply(p5, p8, center);
            DoubleTriangle3D t7 = Triangle3D$.MODULE$.apply(p6, p7, center);
            DoubleTriangle3D t8 = Triangle3D$.MODULE$.apply(p7, p8, center);
            double surfaceArea = this.area(t1) + this.area(t2) + this.area(t3) + this.area(t4) + this.area(t5) + this.area(t6) + this.area(t7) + this.area(t8);
            double planarArea = BoxesRunTime.unboxToDouble((Object)dx.apply(i)) * BoxesRunTime.unboxToDouble((Object)dy.apply(j));
            rugosity.update(i, j, BoxesRunTime.boxToDouble((double)(surfaceArea / planarArea)));
        }));
        return rugosity;
    }

    private double area(Triangle3D<Object, Object> t) {
        Seq<Point3D<Object>> p = t.points();
        Point3D p1 = (Point3D)p.apply(0);
        Point3D p2 = (Point3D)p.apply(1);
        Point3D p3 = (Point3D)p.apply(2);
        double a = p1.distance(p2, Numeric.DoubleIsFractional$.MODULE$) / (double)2;
        double b = p2.distance(p3, Numeric.DoubleIsFractional$.MODULE$) / (double)2;
        double c = p3.distance(p1, Numeric.DoubleIsFractional$.MODULE$) / (double)2;
        double s = (a + b + c) / (double)2;
        return package$.MODULE$.sqrt(s * (s - a) * (s - b) * (s - c));
    }

    public void main(String[] args) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(object) == 2, this::main$$anonfun$1);
        File ingrid = new File(args[0].trim());
        File outgrid = new File(args[1].trim());
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("Reading ").append(ingrid).toString());
        MutableGrid<Object, Object, Object> bathymetry = ASCGridReader$.MODULE$.read(ingrid);
        Predef$.MODULE$.println((Object)"Calculating Rugosity");
        ArrayGrid<Object, Object, Object> rugosity = this.apply(bathymetry);
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("Writing ").append(outgrid).toString());
        ASCGridWriter$.MODULE$.write(outgrid, rugosity, ASCGridWriter$.MODULE$.write$default$3());
    }

    private final Object main$$anonfun$1() {
        return new StringBuilder(105).append("Use as: ").append(this.getClass().getSimpleName()).append(" ingrid outgrid\n").append("\tArgs: ingrid: UTM ASC grid file\n").append("\t      outgrid: Target file to write an ASC grid").toString();
    }
}

