/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.math;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.io.Serializable;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.analysis.solvers.BisectionSolver;
import org.mbari.jcommons.math.DoubleMath;
import org.mbari.jcommons.math.Matlib;
import org.mbari.jcommons.math.Statlib;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.List;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import spire.math.Complex;
import spire.math.Complex$;

public interface Mathematics {
    public static double[] add$(Mathematics $this, double[] a, double[] b) {
        return $this.add(a, b);
    }

    default public double[] add(double[] a, double[] b) {
        Predef$.MODULE$.require(a.length == b.length, () -> Mathematics.add$$anonfun$1(a, b));
        Object object = Predef$.MODULE$.doubleArrayOps(a);
        return (double[])ArrayOps$.MODULE$.indices$extension(object).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> a[i] + b[i]).toArray(ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public static double corr$(Mathematics $this, double[] x, double[] y) {
        return $this.corr(x, y);
    }

    default public double corr(double[] x, double[] y) {
        return Statlib.pearsonsCorrelation((double[])x, (double[])y);
    }

    public static double corrcoef$(Mathematics $this, double[] x, double[] y) {
        return $this.corrcoef(x, y);
    }

    default public double corrcoef(double[] x, double[] y) {
        return Statlib.correlationCoefficient((double[])x, (double[])y);
    }

    public static double[] cumsum$(Mathematics $this, double[] data) {
        return $this.cumsum(data);
    }

    default public double[] cumsum(double[] data) {
        return Matlib.cumsum((double[])data);
    }

    public static double[] diff$(Mathematics $this, double[] x) {
        return $this.diff(x);
    }

    default public double[] diff(double[] x) {
        Object object = Predef$.MODULE$.doubleArrayOps(x);
        if (ArrayOps$.MODULE$.size$extension(object) < 2) {
            return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Double.TYPE));
        }
        return Matlib.diff((double[])x);
    }

    public static double[] divide$(Mathematics $this, double[] a, double[] b) {
        return $this.divide(a, b);
    }

    default public double[] divide(double[] a, double[] b) {
        Predef$.MODULE$.require(a.length == b.length, () -> Mathematics.divide$$anonfun$1(a, b));
        Object object = Predef$.MODULE$.doubleArrayOps(a);
        return (double[])ArrayOps$.MODULE$.indices$extension(object).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> a[i] / b[i]).toArray(ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public static double dot$(Mathematics $this, double[] a, double[] b) {
        return $this.dot(a, b);
    }

    default public double dot(double[] a, double[] b) {
        Predef$.MODULE$.require(a.length == b.length, () -> Mathematics.dot$$anonfun$1(a, b));
        Object object = Predef$.MODULE$.doubleArrayOps(a);
        return BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.indices$extension(object).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> a[i] * b[i]).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static Complex[] fft$(Mathematics $this, double[] data) {
        return $this.fft(data);
    }

    default public Complex<Object>[] fft(double[] data) {
        Object object = Predef$.MODULE$.doubleArrayOps(data);
        double[] complexData = new double[ArrayOps$.MODULE$.size$extension(object) * 2];
        Object object2 = Predef$.MODULE$.doubleArrayOps(data);
        ArrayOps$.MODULE$.indices$extension(object2).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            complexData$1[i * 2] = data[i];
        });
        Object object3 = Predef$.MODULE$.doubleArrayOps(data);
        DoubleFFT_1D fft1d = new DoubleFFT_1D(ArrayOps$.MODULE$.size$extension(object3));
        fft1d.complexForward(complexData);
        Object object4 = Predef$.MODULE$.doubleArrayOps(complexData);
        IndexedSeq f = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object4) - 1).by(2).map((Function1 & Serializable)i -> Complex$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)complexData[BoxesRunTime.unboxToInt((Object)i)]), (Object)BoxesRunTime.boxToDouble((double)complexData[BoxesRunTime.unboxToInt((Object)i) + 1])));
        return (Complex[])f.toArray(ClassTag$.MODULE$.apply(Complex.class));
    }

    public static BigInt fibonacci$(Mathematics $this, int x) {
        return $this.fibonacci(x);
    }

    default public BigInt fibonacci(int x) {
        return (BigInt)this.fibonacciStream(x).last();
    }

    public static LazyList fibonacciStream$(Mathematics $this, int x) {
        return $this.fibonacciStream(x);
    }

    default public LazyList<BigInt> fibonacciStream(int x) {
        Function0 function0 = LazyList$.MODULE$.toDeferrer(() -> Mathematics.fibonacciStream$$anonfun$1(x));
        return LazyList.Deferrer$.MODULE$.$hash$colon$colon$extension(function0, Mathematics::fibonacciStream$$anonfun$2);
    }

    public static double fix$(Mathematics $this, double x) {
        return $this.fix(x);
    }

    default public double fix(double x) {
        return Matlib.fix((double)x);
    }

    public static double fzero$(Mathematics $this, Function1 fn, double start) {
        return $this.fzero((Function1<Object, Object>)fn, start);
    }

    default public double fzero(Function1<Object, Object> fn, double start) {
        BisectionSolver solver = new BisectionSolver();
        UnivariateFunction ufn = new UnivariateFunction(fn){
            private final Function1 fn$1;
            {
                this.fn$1 = fn$4;
            }

            public double value(double p1) {
                return this.fn$1.apply$mcDD$sp(p1);
            }
        };
        return solver.solve(10000, ufn, start);
    }

    public static double fzero$(Mathematics $this, Function1 fn, double min, double max) {
        return $this.fzero((Function1<Object, Object>)fn, min, max);
    }

    default public double fzero(Function1<Object, Object> fn, double min, double max) {
        BisectionSolver solver = new BisectionSolver();
        UnivariateFunction ufn = new UnivariateFunction(fn){
            private final Function1 fn$2;
            {
                this.fn$2 = fn$5;
            }

            public double value(double p1) {
                return this.fn$2.apply$mcDD$sp(p1);
            }
        };
        return solver.solve(10000, ufn, min, max);
    }

    public static int gcd$(Mathematics $this, int a, int b) {
        return $this.gcd(a, b);
    }

    default public int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return this.gcd(b, a % b);
    }

    public static double[] interp1$(Mathematics $this, double[] x, double[] y, double[] xi) {
        return $this.interp1(x, y, xi);
    }

    default public double[] interp1(double[] x, double[] y, double[] xi) {
        return Matlib.interpolate((double[])x, (double[])y, (double[])xi);
    }

    public static double[] extrap1$(Mathematics $this, double[] x, double[] y, double[] xi) {
        return $this.extrap1(x, y, xi);
    }

    default public double[] extrap1(double[] x, double[] y, double[] xi) {
        PolynomialSplineFunction fn = new LinearInterpolator().interpolate(x, y);
        Object[] splines = fn.getPolynomials();
        Object object = Predef$.MODULE$.refArrayOps(splines);
        PolynomialFunction pf0 = (PolynomialFunction)ArrayOps$.MODULE$.head$extension(object);
        Object object2 = Predef$.MODULE$.refArrayOps(splines);
        PolynomialFunction pfn = (PolynomialFunction)ArrayOps$.MODULE$.last$extension(object2);
        double[] knots = fn.getKnots();
        Object object3 = Predef$.MODULE$.doubleArrayOps(knots);
        double k0 = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.head$extension(object3));
        double ko = knots[knots.length - 2];
        Object object4 = Predef$.MODULE$.doubleArrayOps(knots);
        double kn = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.last$extension(object4));
        Object object5 = Predef$.MODULE$.doubleArrayOps(xi);
        return (double[])ArrayOps$.MODULE$.map$extension(object5, (Function1)(JFunction1.mcDD.sp & Serializable)a -> {
            if (a > kn) {
                return pfn.value(a - ko);
            }
            if (a < k0) {
                return pf0.value(a - k0);
            }
            return fn.value(a);
        }, ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public static boolean isprime$(Mathematics $this, Object n, Numeric evidence$1) {
        return $this.isprime(n, evidence$1);
    }

    default public <A> boolean isprime(A n, Numeric<A> evidence$1) {
        Numeric numeric = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
        double nd = numeric.toDouble(n);
        if (nd % 1.0 == 0.0) {
            int ni = (int)scala.math.package$.MODULE$.floor(nd);
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), ni).forall((Function1)(JFunction1.mcZI.sp & Serializable)d -> nd % (double)d != 0.0);
        }
        return false;
    }

    public static double[] linspace$(Mathematics $this, double d1, double d2, int n) {
        return $this.linspace(d1, d2, n);
    }

    default public double[] linspace(double d1, double d2, int n) {
        return Matlib.linspace((double)d1, (double)d2, (int)n);
    }

    public static double[] logspace$(Mathematics $this, double d1, double d2, int n) {
        return $this.logspace(d1, d2, n);
    }

    default public double[] logspace(double d1, double d2, int n) {
        return Matlib.logspace((double)d1, (double)d2, (int)n);
    }

    public static double mod$(Mathematics $this, double a, double b) {
        return $this.mod(a, b);
    }

    default public double mod(double a, double b) {
        return a % b;
    }

    public static double[] multiply$(Mathematics $this, double[] a, double[] b) {
        return $this.multiply(a, b);
    }

    default public double[] multiply(double[] a, double[] b) {
        Predef$.MODULE$.require(a.length == b.length, () -> Mathematics.multiply$$anonfun$1(a, b));
        Object object = Predef$.MODULE$.doubleArrayOps(a);
        return (double[])ArrayOps$.MODULE$.indices$extension(object).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> a[i] * b[i]).toArray(ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public static int near$(Mathematics $this, double[] data, double key, boolean inclusive) {
        return $this.near(data, key, inclusive);
    }

    default public int near(double[] data, double key, boolean inclusive) {
        return Matlib.near((double[])data, (double)key, (boolean)inclusive);
    }

    public static boolean near$default$3$(Mathematics $this) {
        return $this.near$default$3();
    }

    default public boolean near$default$3() {
        return true;
    }

    public static double norm$(Mathematics $this, double[] x) {
        return $this.norm(x);
    }

    default public double norm(double[] x) {
        Object object = Predef$.MODULE$.doubleArrayOps(x);
        return scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcDD.sp & Serializable)v -> v * v, ClassTag$.MODULE$.apply(Double.TYPE))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
    }

    public static double prod$(Mathematics $this, double[] data) {
        return $this.prod(data);
    }

    default public double prod(double[] data) {
        Object object = Predef$.MODULE$.doubleArrayOps(data);
        return BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.fold$extension(object, (Object)BoxesRunTime.boxToDouble((double)1.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, b) -> a * b));
    }

    public static double rem$(Mathematics $this, double x, double y) {
        return $this.rem(x, y);
    }

    default public double rem(double x, double y) {
        return DoubleMath.rem((double)x, (double)y);
    }

    public static int sign$(Mathematics $this, double x) {
        return $this.sign(x);
    }

    default public int sign(double x) {
        return DoubleMath.sign((double)x);
    }

    public static double[] subtract$(Mathematics $this, double[] a, double[] b) {
        return $this.subtract(a, b);
    }

    default public double[] subtract(double[] a, double[] b) {
        Predef$.MODULE$.require(a.length == b.length, () -> Mathematics.subtract$$anonfun$1(a, b));
        Object object = Predef$.MODULE$.doubleArrayOps(a);
        return (double[])ArrayOps$.MODULE$.indices$extension(object).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> a[i] - b[i]).toArray(ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public static double sum$(Mathematics $this, double[] x) {
        return $this.sum(x);
    }

    default public double sum(double[] x) {
        return Matlib.sum((double[])x);
    }

    public static Tuple3 unique$(Mathematics $this, double[] a, String occurrence) {
        return $this.unique(a, occurrence);
    }

    default public Tuple3<double[], int[], int[]> unique(double[] a, String occurrence) {
        String string = occurrence;
        boolean useFirst = "first".equals(string);
        List av = Predef$.MODULE$.wrapDoubleArray(a).toList();
        List c = (List)((StrictOptimizedSeqOps)av.distinct()).sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        int[] ia = (int[])c.map((Function1)(JFunction1.mcID.sp & Serializable)v -> {
            if (useFirst) {
                return av.indexOf((Object)BoxesRunTime.boxToDouble((double)v));
            }
            return av.lastIndexOf((Object)BoxesRunTime.boxToDouble((double)v), av.lastIndexOf$default$2());
        }).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
        int[] ic = (int[])av.map((Function1)(JFunction1.mcID.sp & Serializable)v -> c.indexOf((Object)BoxesRunTime.boxToDouble((double)v))).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
        return Tuple3$.MODULE$.apply(c.toArray(ClassTag$.MODULE$.apply(Double.TYPE)), (Object)ia, (Object)ic);
    }

    public static String unique$default$2$(Mathematics $this) {
        return $this.unique$default$2();
    }

    default public String unique$default$2() {
        return "last";
    }

    private static Object add$$anonfun$1(double[] a$1, double[] b$1) {
        return new StringBuilder(42).append("Whoops, arrays are different sizes (").append(a$1.length).append(" and ").append(b$1.length).append(" ").toString();
    }

    private static Object divide$$anonfun$1(double[] a$3, double[] b$3) {
        return new StringBuilder(42).append("Whoops, arrays are different sizes (").append(a$3.length).append(" and ").append(b$3.length).append(" ").toString();
    }

    private static Object dot$$anonfun$1(double[] a$5, double[] b$5) {
        return new StringBuilder(42).append("Whoops, arrays are different sizes (").append(a$5.length).append(" and ").append(b$5.length).append(" ").toString();
    }

    private static LazyList fib$1$$anonfun$1(BigInt a$7, BigInt b$7) {
        return Mathematics.fib$1(b$7, a$7.$plus(b$7));
    }

    private static BigInt fib$1$$anonfun$2(BigInt a$8) {
        return a$8;
    }

    private static LazyList fib$1(BigInt a, BigInt b) {
        Function0 function0 = LazyList$.MODULE$.toDeferrer(() -> Mathematics.fib$1$$anonfun$1(a, b));
        return LazyList.Deferrer$.MODULE$.$hash$colon$colon$extension(function0, () -> Mathematics.fib$1$$anonfun$2(a));
    }

    private static BigInt fib$default$2$1() {
        return BigInt$.MODULE$.int2bigInt(1);
    }

    private static LazyList fibonacciStream$$anonfun$1(int x$1) {
        return Mathematics.fib$1(package$.MODULE$.BigInt().apply(1), Mathematics.fib$default$2$1()).take(x$1);
    }

    private static BigInt fibonacciStream$$anonfun$2() {
        return BigInt$.MODULE$.int2bigInt(0);
    }

    private static Object multiply$$anonfun$1(double[] a$9, double[] b$8) {
        return new StringBuilder(42).append("Whoops, arrays are different sizes (").append(a$9.length).append(" and ").append(b$8.length).append(" ").toString();
    }

    private static Object subtract$$anonfun$1(double[] a$11, double[] b$10) {
        return new StringBuilder(42).append("Whoops, arrays are different sizes (").append(a$11.length).append(" and ").append(b$10.length).append(" ").toString();
    }
}

