/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.canadiangrid;

import org.mbari.scommons.canadiangrid.Camera$;
import org.mbari.scommons.math.Matlib$;
import scala.Option;
import scala.Predef$;
import scala.math.package$;

public class Camera {
    private final double height;
    private final double alpha;
    private final double beta;
    private final double theta;
    private final Option units;
    private final double planeDistance;
    private final double lensDistance;
    private final double nearViewEdgeDistance;
    private final double farViewEdgeDistance;
    private final double viewHeight;
    private final double viewWidth;

    public static Camera fromDegrees(double d, double d2, double d3, double d4, Option<String> option) {
        return Camera$.MODULE$.fromDegrees(d, d2, d3, d4, option);
    }

    public static Camera fromRadians(double d, double d2, double d3, double d4, Option<String> option) {
        return Camera$.MODULE$.fromRadians(d, d2, d3, d4, option);
    }

    public static Option<String> $lessinit$greater$default$5() {
        return Camera$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> fromDegrees$default$5() {
        return Camera$.MODULE$.fromDegrees$default$5();
    }

    public static Option<String> fromRadians$default$5() {
        return Camera$.MODULE$.fromRadians$default$5();
    }

    public Camera(double height, double alpha, double beta, double theta, Option<String> units) {
        this.height = height;
        this.alpha = alpha;
        this.beta = beta;
        this.theta = theta;
        this.units = units;
        Predef$.MODULE$.require(theta > 0.0 && theta <= Matlib$.MODULE$.HALF_PI(), () -> Camera.$init$$$anonfun$1(theta));
        Predef$.MODULE$.require(alpha > 0.0 && alpha < Math.PI, () -> Camera.$init$$$anonfun$2(alpha));
        Predef$.MODULE$.require(beta > 0.0 && beta < Math.PI, () -> Camera.$init$$$anonfun$3(beta));
        this.planeDistance = height / package$.MODULE$.tan(theta);
        this.lensDistance = height / package$.MODULE$.sin(theta);
        this.nearViewEdgeDistance = height / package$.MODULE$.tan(theta + alpha / (double)2);
        this.farViewEdgeDistance = height / package$.MODULE$.tan(theta - alpha / (double)2);
        this.viewHeight = this.farViewEdgeDistance() - this.nearViewEdgeDistance();
        this.viewWidth = this.lensDistance() * package$.MODULE$.tan(beta / (double)2) * (double)2;
    }

    public double height() {
        return this.height;
    }

    public double alpha() {
        return this.alpha;
    }

    public double beta() {
        return this.beta;
    }

    public double theta() {
        return this.theta;
    }

    public Option<String> units() {
        return this.units;
    }

    public double planeDistance() {
        return this.planeDistance;
    }

    public double lensDistance() {
        return this.lensDistance;
    }

    public double nearViewEdgeDistance() {
        return this.nearViewEdgeDistance;
    }

    public double farViewEdgeDistance() {
        return this.farViewEdgeDistance;
    }

    public double viewHeight() {
        return this.viewHeight;
    }

    public double viewWidth() {
        return this.viewWidth;
    }

    private static final Object $init$$$anonfun$1(double theta$1) {
        return new StringBuilder(58).append("alpha must be greater than 0 and less than Pi/2. You gave ").append(theta$1).toString();
    }

    private static final Object $init$$$anonfun$2(double alpha$1) {
        return new StringBuilder(55).append("beta must be greater than 0 and less than Pi. You gave ").append(alpha$1).toString();
    }

    private static final Object $init$$$anonfun$3(double beta$1) {
        return new StringBuilder(55).append("beta must be greater than 0 and less than Pi. You gave ").append(beta$1).toString();
    }
}

