/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.canadiangrid;

import org.mbari.scommons.canadiangrid.Camera;
import org.mbari.scommons.canadiangrid.Pixel$;
import org.mbari.scommons.geometry.DoublePoint2D;
import org.mbari.scommons.geometry.Point2D;
import org.mbari.scommons.geometry.Point2D$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class Pixel {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Pixel.class.getDeclaredField("point$lzy1"));
    private final Camera camera;
    private final int width;
    private final int height;
    private final int x;
    private final int y;
    private final double alpha;
    private final double beta;
    private final double xDistance;
    private final double yDistance;
    private volatile Object point$lzy1;

    public static List<Pixel> imageCorners(Camera camera, int n, int n2) {
        return Pixel$.MODULE$.imageCorners(camera, n, n2);
    }

    public Pixel(Camera camera, int width, int height, int x, int y) {
        this.camera = camera;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        Predef$.MODULE$.require(x >= 0 && x < width, () -> Pixel.$init$$$anonfun$1(width, x));
        Predef$.MODULE$.require(y >= 0 && y < width, () -> Pixel.$init$$$anonfun$2(height, x));
        double bp = (double)height / 2.0;
        double ip = bp - (double)y;
        this.alpha = package$.MODULE$.atan(ip * package$.MODULE$.tan(camera.alpha() / 2.0) / bp);
        int gp = width / 2;
        int ip2 = gp - x;
        this.beta = package$.MODULE$.atan((double)ip2 * package$.MODULE$.tan(camera.beta() / 2.0) / (double)gp) * (double)-1;
        double oiDistance = camera.height() / package$.MODULE$.sin(camera.theta() - this.alpha());
        this.xDistance = oiDistance * package$.MODULE$.tan(this.beta());
        this.yDistance = camera.height() / package$.MODULE$.tan(camera.theta() - this.alpha());
    }

    public Camera camera() {
        return this.camera;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public double alpha() {
        return this.alpha;
    }

    public double beta() {
        return this.beta;
    }

    public double xDistance() {
        return this.xDistance;
    }

    public double yDistance() {
        return this.yDistance;
    }

    public Point2D<Object> point() {
        Object object = this.point$lzy1;
        if (object instanceof Point2D) {
            return (Point2D)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Point2D)this.point$lzyINIT1();
    }

    private Object point$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.point$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DoublePoint2D doublePoint2D = null;
                    try {
                        doublePoint2D = Point2D$.MODULE$.apply(this.xDistance(), this.yDistance());
                        object2 = doublePoint2D == null ? LazyVals.NullValue$.MODULE$ : doublePoint2D;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.point$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return doublePoint2D;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Object $init$$$anonfun$1(int width$1, int x$1) {
        return new StringBuilder(39).append("x must be between 0 and ").append(width$1 - 1).append(". You supplied ").append(x$1).toString();
    }

    private static final Object $init$$$anonfun$2(int height$1, int x$2) {
        return new StringBuilder(39).append("y must be between 0 and ").append(height$1 - 1).append(". You supplied ").append(x$2).toString();
    }
}

