/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.etc.jdk;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import scala.runtime.ModuleSerializationProxy;

public final class Images$
implements Serializable {
    public static final Images$ MODULE$ = new Images$();

    private Images$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Images$.class);
    }

    public void saveImage(RenderedImage image, Path target) throws IOException {
        Path parent = target.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        String path = target.toAbsolutePath().normalize().toString();
        int dotIdx = path.lastIndexOf(".");
        String ext = path.substring(dotIdx + 1);
        ImageIO.write(image, ext, target.toFile());
    }

    public byte[] toJpegByteArray(BufferedImage image) {
        return this.toImageByteArray(image, "jpg");
    }

    public byte[] toPngByteArray(BufferedImage image) {
        return this.toImageByteArray(image, "png");
    }

    private byte[] toImageByteArray(BufferedImage image, String format) {
        ByteArrayOutputStream os0 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, os0);
        byte[] imageBytes = os0.toByteArray();
        os0.close();
        return imageBytes;
    }
}

