/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.etc.jdk;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import scala.Function1;
import scala.Option;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class Instants$
implements Serializable {
    private static final DateTimeFormatter compactTimeFormatter;
    private static final Seq<DateTimeFormatter> formatters;
    public static final Instants$ MODULE$;

    private Instants$() {
    }

    static {
        MODULE$ = new Instants$();
        compactTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssX").withZone(ZoneOffset.UTC);
        formatters = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DateTimeFormatter[]{compactTimeFormatter, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss.SSSX").withZone(ZoneOffset.UTC), DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss.SSSSSSX").withZone(ZoneOffset.UTC), DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_INSTANT}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Instants$.class);
    }

    public Option<Instant> parseIso8601(String s) {
        return ((LazyList)formatters.to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).flatMap((Function1 & Serializable)_$1 -> this.tryToParse(s, (DateTimeFormatter)_$1)).headOption();
    }

    public String compactFormat(Instant instant) {
        return compactTimeFormatter.format(instant);
    }

    private Option<Instant> tryToParse(String s, DateTimeFormatter formatter) {
        return Try$.MODULE$.apply(() -> this.tryToParse$$anonfun$1(formatter, s)).toOption();
    }

    public Instant roundToHour(Instant i) {
        ZonedDateTime z = i.atZone(ZoneOffset.UTC);
        int minutes = z.getMinute();
        ZonedDateTime adjustedTime = minutes >= 30 ? z.plusHours(1L) : z;
        ZonedDateTime truncatedTime = adjustedTime.truncatedTo(ChronoUnit.HOURS);
        return truncatedTime.toInstant();
    }

    private final Instant tryToParse$$anonfun$1(DateTimeFormatter formatter$1, String s$2) {
        return Instant.from(formatter$1.parse(s$2));
    }
}

