/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.gis;

import java.io.Serializable;
import org.mbari.scommons.geometry.IntPoint2D;
import org.mbari.scommons.geometry.Point2D;
import org.mbari.scommons.gis.Grid;
import org.mbari.scommons.math.Matlib$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public class GridSearcher<A, B> {
    private final Grid grid;
    private final double[] xCoords;
    private final double[] yCoords;
    private final boolean isXForward;
    private final boolean isYForward;

    public GridSearcher(Grid<A, A, B> grid, Numeric<A> evidence$1) {
        this.grid = grid;
        Numeric numeric = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
        double x0 = numeric.toDouble(grid.x().head());
        double x1 = numeric.toDouble(grid.x().last());
        boolean isXForward = x0 < x1;
        double y0 = numeric.toDouble(grid.y().head());
        double y1 = numeric.toDouble(grid.y().last());
        boolean isYForward = y0 < y1;
        IndexedSeq xx = isXForward ? grid.x() : (IndexedSeq)grid.x().reverse();
        IndexedSeq yy = isYForward ? grid.y() : (IndexedSeq)grid.y().reverse();
        Tuple4 tuple4 = Tuple4$.MODULE$.apply(((IterableOnceOps)xx.map((Function1 & Serializable)_$1 -> numeric.toDouble(_$1))).toArray(ClassTag$.MODULE$.apply(Double.TYPE)), ((IterableOnceOps)yy.map((Function1 & Serializable)_$2 -> numeric.toDouble(_$2))).toArray(ClassTag$.MODULE$.apply(Double.TYPE)), (Object)BoxesRunTime.boxToBoolean((boolean)isXForward), (Object)BoxesRunTime.boxToBoolean((boolean)isYForward));
        this.xCoords = (double[])tuple4._1();
        this.yCoords = (double[])tuple4._2();
        this.isXForward = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
        this.isYForward = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
    }

    public Grid<A, A, B> grid() {
        return this.grid;
    }

    public <C> Option<Point2D<Object>> search(C x, C y, Numeric<C> evidence$1) {
        Numeric numericC = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
        double xd = numericC.toDouble(x);
        double yd = numericC.toDouble(y);
        int i = Matlib$.MODULE$.near(this.xCoords, xd, true);
        if (i >= 0) {
            int j = Matlib$.MODULE$.near(this.yCoords, yd, true);
            if (j >= 0) {
                int ii = this.isXForward ? i : this.grid().x().size() - i - 1;
                int jj = this.isYForward ? j : this.grid().y().size() - j - 1;
                return Option$.MODULE$.apply((Object)new IntPoint2D(ii, jj));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }
}

