/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.scommons.math;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.mbari.jcommons.math.Matlib;
import org.mbari.scommons.math.KDE$;
import org.mbari.scommons.math.KDEResult;
import org.mbari.scommons.math.Mathematics;
import org.mbari.scommons.math.Probabilities;
import org.mbari.scommons.math.Statistics;
import org.mbari.scommons.math.Trigonometry;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class Matlib$
implements Mathematics,
Probabilities,
Statistics,
Trigonometry,
Serializable {
    private static double TAU;
    private static double HALF_PI;
    public static final Matlib$ MODULE$;

    private Matlib$() {
    }

    static {
        MODULE$ = new Matlib$();
        Trigonometry.$init$(MODULE$);
        Statics.releaseFence();
    }

    @Override
    public double TAU() {
        return TAU;
    }

    @Override
    public double HALF_PI() {
        return HALF_PI;
    }

    @Override
    public void org$mbari$scommons$math$Trigonometry$_setter_$TAU_$eq(double x$0) {
        TAU = x$0;
    }

    @Override
    public void org$mbari$scommons$math$Trigonometry$_setter_$HALF_PI_$eq(double x$0) {
        HALF_PI = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Matlib$.class);
    }

    public double[] relativecdf(double[] y, double[] y0, double[] r) {
        Tuple2<double[], double[]> tuple2 = this.tocdf(y);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double[] c = (double[])tuple2._1();
        double[] x = (double[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)c, (Object)x);
        double[] c2 = (double[])tuple22._1();
        double[] x2 = (double[])tuple22._2();
        Tuple2<double[], double[]> tuple23 = this.tocdf(y0);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        double[] c0 = (double[])tuple23._1();
        double[] x0 = (double[])tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)c0, (Object)x0);
        double[] c02 = (double[])tuple24._1();
        double[] x02 = (double[])tuple24._2();
        double[] q0 = this.prctile(y0, r);
        double[] f0 = this.interp1(x02, c02, q0);
        double[] f = this.interp1(x2, c2, q0);
        Object object = Predef$.MODULE$.doubleArrayOps(f);
        return (double[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> f[i] / f0[i]).toArray(ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public double[] relativepdf(double[] y, double[] y0, double[] r) {
        double min_ = package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(y).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(y0).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        double max_ = package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(y).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(y0).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        Object object = Predef$.MODULE$.doubleArrayOps(y);
        Object object2 = Predef$.MODULE$.doubleArrayOps(y0);
        int n = package$.MODULE$.max(ArrayOps$.MODULE$.size$extension(object), ArrayOps$.MODULE$.size$extension(object2)) * 2;
        KDEResult p = KDE$.MODULE$.apply(y, n, min_, max_);
        KDEResult p0 = KDE$.MODULE$.apply(y0, n, min_, max_);
        double[] q0 = this.prctile(y0, r);
        double[] f0 = this.interp1(p0.x(), p0.pdf(), q0);
        double[] f = this.interp1(p.x(), p.pdf(), q0);
        Object object3 = Predef$.MODULE$.doubleArrayOps(f);
        return (double[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object3)).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> f[i] / f0[i]).toArray(ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public double trapz(double[] x, double[] y) {
        return Matlib.trapz((double[])x, (double[])y);
    }

    public Tuple2<double[], double[]> tocdf(double[] data) {
        Object object = Predef$.MODULE$.doubleArrayOps(data);
        Object object2 = Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.filter$extension(object, (Function1)(JFunction1.mcZD.sp & Serializable)_$1 -> !Predef$.MODULE$.double2Double(_$1).isNaN()));
        double[] s = (double[])ArrayOps$.MODULE$.sorted$extension(object2, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        double d = Double.NEGATIVE_INFINITY;
        Object object3 = Predef$.MODULE$.doubleArrayOps(s);
        Object object4 = Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.distinct$extension(object3));
        Object object5 = Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.$plus$colon$extension(object4, (Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.apply(Double.TYPE)));
        double[] binEdges = (double[])ArrayOps$.MODULE$.$colon$plus$extension(object5, (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), ClassTag$.MODULE$.apply(Double.TYPE));
        double[] binCounts = this.histc(s, binEdges);
        double bcSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(binCounts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        Object object6 = Predef$.MODULE$.doubleArrayOps(this.cumsum(binCounts));
        double[] sumCounts = (double[])ArrayOps$.MODULE$.map$extension(object6, (Function1)(JFunction1.mcDD.sp & Serializable)_$2 -> _$2 / bcSum, ClassTag$.MODULE$.apply(Double.TYPE));
        Object object7 = Predef$.MODULE$.doubleArrayOps(sumCounts);
        double[] c = (double[])this.subset(sumCounts, (Seq<Object>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object7) - 1), ClassTag$.MODULE$.apply(Double.TYPE));
        Tuple3 tuple3 = this.unique(data, this.unique$default$2());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double[] x = (double[])tuple3._1();
        double[] x2 = x;
        return Tuple2$.MODULE$.apply((Object)c, (Object)x2);
    }

    public <A> Object subset(Object data, Seq<Object> idx, ClassTag<A> evidence$1) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), idx.size()).map((Function1 & Serializable)i -> this.subset$$anonfun$1(data, idx, BoxesRunTime.unboxToInt((Object)i))).toArray(evidence$1);
    }

    public <A> Seq<Object> find(Object data, Function1<A, Object> predicate) {
        Object object = Predef$.MODULE$.genericArrayOps(data);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)i -> BoxesRunTime.unboxToBoolean((Object)predicate.apply(i._1()))));
        Object object4 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$3 -> BoxesRunTime.unboxToInt((Object)_$3._2()), ClassTag$.MODULE$.apply(Integer.TYPE)));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object4);
    }

    private <T> Seq<Object> sortWith(Object x, Comparator<T> comparator) {
        Object object = Predef$.MODULE$.genericArrayOps(x);
        Object[] indices = (Integer[])ArrayOps$.MODULE$.indices$extension(object).map((Function1 & Serializable)i -> this.$anonfun$3(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(Integer.class));
        Comparator<Integer> intComparator = new Comparator<Integer>(comparator, x){
            private final Comparator comparator$1;
            private final Object x$2;
            {
                this.comparator$1 = comparator$2;
                this.x$2 = x$3;
            }

            public int compare(Integer i0, Integer i1) {
                return this.comparator$1.compare(ScalaRunTime$.MODULE$.array_apply(this.x$2, Predef$.MODULE$.Integer2int(i0)), ScalaRunTime$.MODULE$.array_apply(this.x$2, Predef$.MODULE$.Integer2int(i1)));
            }
        };
        Arrays.sort(indices, intComparator);
        Object object2 = Predef$.MODULE$.refArrayOps(indices);
        Object object3 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)i -> Predef$.MODULE$.Integer2int(i), ClassTag$.MODULE$.apply(Integer.TYPE)));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object3);
    }

    public <A> Seq<Object> sort(Object x, Function2<A, A, Object> lt) {
        Comparator comparator = new Comparator<A>(lt){
            private final Function2 lt$1;
            {
                this.lt$1 = lt$2;
            }

            public int compare(Object a, Object b) {
                if (BoxesRunTime.unboxToBoolean((Object)this.lt$1.apply(a, b))) {
                    return -1;
                }
                return 1;
            }
        };
        return this.sortWith(x, comparator);
    }

    public <A> Seq<Object> sort(Object x, Ordering<A> evidence$1) {
        Ordering ordering = (Ordering)Predef$.MODULE$.implicitly(evidence$1);
        Comparator comparator = new Comparator<A>(ordering){
            private final Ordering ordering$1;
            {
                this.ordering$1 = ordering$2;
            }

            public int compare(Object a, Object b) {
                return this.ordering$1.compare(a, b);
            }
        };
        return this.sortWith(x, comparator);
    }

    private final /* synthetic */ Object subset$$anonfun$1(Object data$1, Seq idx$1, int i) {
        return ScalaRunTime$.MODULE$.array_apply(data$1, BoxesRunTime.unboxToInt((Object)idx$1.apply(i)));
    }

    private final /* synthetic */ Integer $anonfun$3(int i) {
        return Predef$.MODULE$.int2Integer(i);
    }
}

