/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.associations;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.AssociationSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.models.Unauthorized;
import org.mbari.vars.annosaurus.sdk.kiota.v1.associations.bulk.BulkRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.associations.conceptassociations.ConceptassociationsRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.associations.delete.DeleteRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.associations.item.AssociationUuItemRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.associations.toconcept.ToconceptRequestBuilder;

public class AssociationsRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public BulkRequestBuilder bulk() {
        return new BulkRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ConceptassociationsRequestBuilder conceptassociations() {
        return new ConceptassociationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DeleteRequestBuilder deletePath() {
        return new DeleteRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ToconceptRequestBuilder toconcept() {
        return new ToconceptRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AssociationUuItemRequestBuilder byAssociationUuId(@Nonnull UUID associationUuId) {
        Objects.requireNonNull(associationUuId);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("associationUu%2Did", associationUuId);
        return new AssociationUuItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public AssociationsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/associations", pathParameters);
    }

    public AssociationsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/associations", rawUrl);
    }

    @Nullable
    public AssociationSC post(@Nonnull AssociationSC body) {
        return this.post(body, null);
    }

    @Nullable
    public AssociationSC post(@Nonnull AssociationSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return (AssociationSC)this.requestAdapter.send(requestInfo, errorMapping, AssociationSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull AssociationSC body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull AssociationSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public AssociationsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new AssociationsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

