/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.auth;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.AuthorizationSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.models.Unauthorized;

public class AuthRequestBuilder
extends BaseRequestBuilder {
    public AuthRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/auth", pathParameters);
    }

    public AuthRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/auth", rawUrl);
    }

    @Nullable
    public AuthorizationSC post() {
        return this.post(null);
    }

    @Nullable
    public AuthorizationSC post(@Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toPostRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return (AuthorizationSC)this.requestAdapter.send(requestInfo, errorMapping, AuthorizationSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation() {
        return this.toPostRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public AuthRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new AuthRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

