/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.images;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.ImageCreateSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.ImageSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.models.Unauthorized;
import org.mbari.vars.annosaurus.sdk.kiota.v1.images.item.WithImageReferenceUuItemRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.images.name.NameRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.images.url.UrlRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.images.videoreference.VideoreferenceRequestBuilder;

public class ImagesRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public NameRequestBuilder name() {
        return new NameRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public UrlRequestBuilder url() {
        return new UrlRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VideoreferenceRequestBuilder videoreference() {
        return new VideoreferenceRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WithImageReferenceUuItemRequestBuilder byImageReferenceUuid(@Nonnull UUID imageReferenceUuid) {
        Objects.requireNonNull(imageReferenceUuid);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("imageReferenceUuid", imageReferenceUuid);
        return new WithImageReferenceUuItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public ImagesRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/images", pathParameters);
    }

    public ImagesRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/images", rawUrl);
    }

    @Nullable
    public ImageSC post(@Nonnull ImageCreateSC body) {
        return this.post(body, null);
    }

    @Nullable
    public ImageSC post(@Nonnull ImageCreateSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return (ImageSC)this.requestAdapter.send(requestInfo, errorMapping, ImageSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ImageCreateSC body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ImageCreateSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public ImagesRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ImagesRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

