/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.r1;

import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mbari.vars.annosaurus.sdk.AnnosaurusFactory;
import org.mbari.vars.annosaurus.sdk.kiota.Annosaurus;
import org.mbari.vars.annosaurus.sdk.kiota.models.ConcurrentRequestCountSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.CountForVideoReferenceSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.MultiRequestCountSC;
import org.mbari.vars.annosaurus.sdk.r1.AnnotationService;
import org.mbari.vars.annosaurus.sdk.r1.models.AncillaryData;
import org.mbari.vars.annosaurus.sdk.r1.models.AncillaryDataDeleteCount;
import org.mbari.vars.annosaurus.sdk.r1.models.Annotation;
import org.mbari.vars.annosaurus.sdk.r1.models.AnnotationCount;
import org.mbari.vars.annosaurus.sdk.r1.models.Association;
import org.mbari.vars.annosaurus.sdk.r1.models.CachedVideoReference;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptAssociationRequest;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptAssociationResponse;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptCount;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptsRenamed;
import org.mbari.vars.annosaurus.sdk.r1.models.ConcurrentRequest;
import org.mbari.vars.annosaurus.sdk.r1.models.ConcurrentRequestCount;
import org.mbari.vars.annosaurus.sdk.r1.models.Count;
import org.mbari.vars.annosaurus.sdk.r1.models.Image;
import org.mbari.vars.annosaurus.sdk.r1.models.ImagedMoment;
import org.mbari.vars.annosaurus.sdk.r1.models.Index;
import org.mbari.vars.annosaurus.sdk.r1.models.MultiRequest;
import org.mbari.vars.annosaurus.sdk.r1.models.MultiRequestCount;
import org.mbari.vars.annosaurus.sdk.r1.models.ObservationsUpdate;

public class AnnosaurusKiotaClient
implements AnnotationService {
    private final Annosaurus annosaurus;
    protected final ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();

    public AnnosaurusKiotaClient(URI baseUri, String apiKey) {
        this.annosaurus = AnnosaurusFactory.create(baseUri.toString(), apiKey);
    }

    @Override
    public CompletableFuture<AnnotationCount> countAnnotations(UUID videoReferenceUuid) {
        return CompletableFuture.supplyAsync(() -> {
            CountForVideoReferenceSC response = this.annosaurus.v1().observations().videoreference().count().byVideoReferenceUuid(videoReferenceUuid).get();
            return new AnnotationCount(response.getVideoReferenceUuid(), response.getCount());
        }, this.executor);
    }

    @Override
    public CompletableFuture<List<AnnotationCount>> countAnnotationsGroupByVideoReferenceUuid() {
        return CompletableFuture.supplyAsync(() -> {
            List<CountForVideoReferenceSC> response = this.annosaurus.v1().observations().counts().get();
            return response.stream().map(r -> new AnnotationCount(r.getVideoReferenceUuid(), r.getCount())).toList();
        }, this.executor);
    }

    @Override
    public CompletableFuture<ConcurrentRequestCount> countByConcurrentRequest(ConcurrentRequest concurrentRequest) {
        org.mbari.vars.annosaurus.sdk.kiota.models.ConcurrentRequest cr = new org.mbari.vars.annosaurus.sdk.kiota.models.ConcurrentRequest();
        cr.setVideoReferenceUuids(concurrentRequest.getVideoReferenceUuids());
        cr.setStartTimestamp(concurrentRequest.getStartTimestamp().toString());
        cr.setEndTimestamp(concurrentRequest.getEndTimestamp().toString());
        return CompletableFuture.supplyAsync(() -> {
            ConcurrentRequestCountSC response = this.annosaurus.v1().annotations().concurrent().count().post(cr);
            return new ConcurrentRequestCount(concurrentRequest, response.getCount());
        }, this.executor);
    }

    @Override
    public CompletableFuture<MultiRequestCount> countByMultiRequest(MultiRequest multiRequest) {
        org.mbari.vars.annosaurus.sdk.kiota.models.MultiRequest mr = new org.mbari.vars.annosaurus.sdk.kiota.models.MultiRequest();
        mr.setVideoReferenceUuids(multiRequest.getVideoReferenceUuids());
        return CompletableFuture.supplyAsync(() -> {
            MultiRequestCountSC response = this.annosaurus.v1().annotations().multi().count().post(mr);
            return new MultiRequestCount(multiRequest, response.getCount());
        }, this.executor);
    }

    @Override
    public CompletableFuture<List<AnnotationCount>> countImagedMomentsGroupByVideoReferenceUuid() {
        throw new UnsupportedOperationException("Unimplemented method 'countImagedMomentsGroupByVideoReferenceUuid'");
    }

    @Override
    public CompletableFuture<ConceptCount> countObservationsByConcept(String concept) {
        throw new UnsupportedOperationException("Unimplemented method 'countObservationsByConcept'");
    }

    @Override
    public CompletableFuture<AnnotationCount> countImagedMomentsModifiedBefore(UUID videoReferenceUuid, Instant date) {
        throw new UnsupportedOperationException("Unimplemented method 'countImagedMomentsModifiedBefore'");
    }

    @Override
    public CompletableFuture<Annotation> createAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException("Unimplemented method 'createAnnotation'");
    }

    @Override
    public CompletableFuture<Collection<Annotation>> createAnnotations(Collection<Annotation> annotations) {
        throw new UnsupportedOperationException("Unimplemented method 'createAnnotations'");
    }

    @Override
    public CompletableFuture<Association> createAssociation(UUID observationUuid, Association association) {
        throw new UnsupportedOperationException("Unimplemented method 'createAssociation'");
    }

    @Override
    public CompletableFuture<Association> createAssociation(UUID observationUuid, Association association, UUID associationUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'createAssociation'");
    }

    @Override
    public CompletableFuture<Image> createImage(Image image) {
        throw new UnsupportedOperationException("Unimplemented method 'createImage'");
    }

    @Override
    public CompletableFuture<List<AncillaryData>> createOrUpdateAncillaryData(List<AncillaryData> ancillaryData) {
        throw new UnsupportedOperationException("Unimplemented method 'createOrUpdateAncillaryData'");
    }

    @Override
    public CompletableFuture<CachedVideoReference> createCachedVideoReference(CachedVideoReference cvr) {
        throw new UnsupportedOperationException("Unimplemented method 'createCachedVideoReference'");
    }

    @Override
    public CompletableFuture<AncillaryDataDeleteCount> deleteAncillaryDataByVideoReference(UUID videoReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteAncillaryDataByVideoReference'");
    }

    @Override
    public CompletableFuture<Boolean> deleteAnnotation(UUID observationUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteAnnotation'");
    }

    @Override
    public CompletableFuture<Boolean> deleteAnnotations(Collection<UUID> observationUuids) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteAnnotations'");
    }

    @Override
    public CompletableFuture<Boolean> deleteAssociation(UUID associationUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteAssociation'");
    }

    @Override
    public CompletableFuture<Boolean> deleteAssociations(Collection<UUID> associationUuids) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteAssociations'");
    }

    @Override
    public CompletableFuture<Boolean> deleteImage(UUID imageReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteImage'");
    }

    @Override
    public CompletableFuture<Annotation> deleteDuration(UUID observationUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteDuration'");
    }

    @Override
    public CompletableFuture<Boolean> deleteCacheVideoReference(UUID uuid) {
        throw new UnsupportedOperationException("Unimplemented method 'deleteCacheVideoReference'");
    }

    @Override
    public CompletableFuture<List<String>> findActivities() {
        throw new UnsupportedOperationException("Unimplemented method 'findActivities'");
    }

    @Override
    public CompletableFuture<List<UUID>> findAllVideoReferenceUuids() {
        throw new UnsupportedOperationException("Unimplemented method 'findAllVideoReferenceUuids'");
    }

    @Override
    public CompletableFuture<AncillaryData> findAncillaryData(UUID observationUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findAncillaryData'");
    }

    @Override
    public CompletableFuture<List<AncillaryData>> findAncillaryDataByVideoReference(UUID videoReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findAncillaryDataByVideoReference'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findByConcept(String concept, Boolean data) {
        throw new UnsupportedOperationException("Unimplemented method 'findByConcept'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findByConcept(String concept, Long limit, Long offset, Boolean data) {
        throw new UnsupportedOperationException("Unimplemented method 'findByConcept'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findAnnotations'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid, boolean data) {
        throw new UnsupportedOperationException("Unimplemented method 'findAnnotations'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid, Long limit, Long offset) {
        throw new UnsupportedOperationException("Unimplemented method 'findAnnotations'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid, Long limit, Long offset, Boolean data) {
        throw new UnsupportedOperationException("Unimplemented method 'findAnnotations'");
    }

    @Override
    public CompletableFuture<Association> findAssociationByUuid(UUID associationUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findAssociationByUuid'");
    }

    @Override
    public CompletableFuture<ConceptAssociationResponse> findByConceptAssociationRequest(ConceptAssociationRequest request) {
        throw new UnsupportedOperationException("Unimplemented method 'findByConceptAssociationRequest'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findByConcurrentRequest(ConcurrentRequest concurrentRequest, long limit, long offset) {
        throw new UnsupportedOperationException("Unimplemented method 'findByConcurrentRequest'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findByImageReference(UUID imageReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findByImageReference'");
    }

    @Override
    public CompletableFuture<List<Annotation>> findByMultiRequest(MultiRequest multiRequest, long limit, long offset) {
        throw new UnsupportedOperationException("Unimplemented method 'findByMultiRequest'");
    }

    @Override
    public CompletableFuture<Annotation> findByUuid(UUID observationUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findByUuid'");
    }

    @Override
    public CompletableFuture<List<Association>> findByVideoReferenceAndLinkName(UUID videoReferenceUuid, String linkName) {
        throw new UnsupportedOperationException("Unimplemented method 'findByVideoReferenceAndLinkName'");
    }

    @Override
    public CompletableFuture<List<Association>> findByVideoReferenceAndLinkNameAndConcept(UUID videoReferenceUuid, String linkName, String concept) {
        throw new UnsupportedOperationException("Unimplemented method 'findByVideoReferenceAndLinkNameAndConcept'");
    }

    @Override
    public CompletableFuture<List<String>> findGroups() {
        throw new UnsupportedOperationException("Unimplemented method 'findGroups'");
    }

    @Override
    public CompletableFuture<Image> findImageByUrl(URL url) {
        throw new UnsupportedOperationException("Unimplemented method 'findImageByUrl'");
    }

    @Override
    public CompletableFuture<Image> findImageByUuid(UUID imageReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findImageByUuid'");
    }

    @Override
    public CompletableFuture<List<Image>> findImagesByVideoReferenceUuid(UUID videoReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findImagesByVideoReferenceUuid'");
    }

    @Override
    public CompletableFuture<List<ImagedMoment>> findImagedMomentsByVideoReferenceUuid(UUID videoReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findImagedMomentsByVideoReferenceUuid'");
    }

    @Override
    public CompletableFuture<List<Index>> findIndicesByVideoReferenceUuid(UUID videoReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findIndicesByVideoReferenceUuid'");
    }

    @Override
    public CompletableFuture<CachedVideoReference> findVideoReferenceByVideoReferenceUuid(UUID videoReferenceUuid) {
        throw new UnsupportedOperationException("Unimplemented method 'findVideoReferenceByVideoReferenceUuid'");
    }

    @Override
    public CompletableFuture<Collection<AncillaryData>> merge(UUID videoReferenceUuid, Collection<AncillaryData> data) {
        throw new UnsupportedOperationException("Unimplemented method 'merge'");
    }

    @Override
    public CompletableFuture<ConceptsRenamed> renameConcepts(String oldConcept, String newConcept) {
        throw new UnsupportedOperationException("Unimplemented method 'renameConcepts'");
    }

    @Override
    public CompletableFuture<Annotation> updateAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException("Unimplemented method 'updateAnnotation'");
    }

    @Override
    public CompletableFuture<Collection<Annotation>> updateAnnotations(Collection<Annotation> annotations) {
        throw new UnsupportedOperationException("Unimplemented method 'updateAnnotations'");
    }

    @Override
    public CompletableFuture<Association> updateAssociation(Association association) {
        throw new UnsupportedOperationException("Unimplemented method 'updateAssociation'");
    }

    @Override
    public CompletableFuture<Collection<Association>> updateAssociations(Collection<Association> associations) {
        throw new UnsupportedOperationException("Unimplemented method 'updateAssociations'");
    }

    @Override
    public CompletableFuture<Image> updateImage(Image image) {
        throw new UnsupportedOperationException("Unimplemented method 'updateImage'");
    }

    @Override
    public CompletableFuture<List<Index>> updateIndexRecordedTimestamps(Collection<Index> indices) {
        throw new UnsupportedOperationException("Unimplemented method 'updateIndexRecordedTimestamps'");
    }

    @Override
    public CompletableFuture<Count> updateObservations(ObservationsUpdate update) {
        throw new UnsupportedOperationException("Unimplemented method 'updateObservations'");
    }

    @Override
    public CompletableFuture<Collection<Annotation>> updateRecordedTimestampsForTapes(Collection<Annotation> annotations) {
        throw new UnsupportedOperationException("Unimplemented method 'updateRecordedTimestampsForTapes'");
    }

    @Override
    public CompletableFuture<Optional<Index>> updateRecordedTimestamp(UUID imagedMomentUuid, Instant recordedTimestamp) {
        throw new UnsupportedOperationException("Unimplemented method 'updateRecordedTimestamp'");
    }

    @Override
    public CompletableFuture<CachedVideoReference> updateCachedVideoReference(CachedVideoReference cvr) {
        throw new UnsupportedOperationException("Unimplemented method 'updateCachedVideoReference'");
    }
}

