/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.r1.models;

import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.mbari.vars.annosaurus.sdk.r1.models.Details;

public class Association
implements Cloneable,
Details {
    private UUID uuid;
    private String linkName;
    private String toConcept;
    private String linkValue;
    private String mimeType;
    private Instant lastUpdatedTime;
    public static final String VALUE_NIL = "nil";
    public static final String VALUE_SELF = "self";
    public static final Association NIL = new Association("nil", "nil", "nil");
    public static final String NAME_LOCALIZATION = "bounding box";
    public static final String MIME_TYPE_DEFAULT = "text/plain";
    public static final Function<Association, Optional<Integer>> ASSOCATION_TO_IDENTITY_REF_NUM = a -> {
        try {
            return Optional.of(Integer.parseInt(a.getLinkValue()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    };
    public static final Comparator<Association> IDENTITY_REF_NUM_COMPARATOR = (a, b) -> {
        Optional<Integer> as = ASSOCATION_TO_IDENTITY_REF_NUM.apply((Association)a);
        Optional<Integer> bs = ASSOCATION_TO_IDENTITY_REF_NUM.apply((Association)b);
        if (as.isPresent() && bs.isPresent()) {
            return as.get().compareTo(bs.get());
        }
        return a.getLinkValue().compareTo(b.getLinkValue());
    };
    public static final Comparator<Association> ALPHABETICAL_COMPARATOR = Comparator.comparing(Association::toString);

    public Association(String linkName, String toConcept, String linkValue, String mimeType) {
        this.linkName = linkName;
        this.toConcept = toConcept == null ? VALUE_NIL : toConcept;
        this.linkValue = linkValue == null ? VALUE_NIL : linkValue;
        this.mimeType = mimeType == null ? MIME_TYPE_DEFAULT : mimeType;
    }

    public Association(String linkName, String toConcept, String linkValue) {
        this(linkName, toConcept, linkValue, MIME_TYPE_DEFAULT);
    }

    public Association(String linkName, String toConcept, String linkValue, String mimeType, UUID uuid) {
        this(linkName, toConcept, linkValue, mimeType);
        this.uuid = uuid;
    }

    public Association(String linkName, String toConcept, String linkValue, String mimeType, UUID uuid, Instant lastUpdatedTime) {
        this(linkName, toConcept, linkValue, mimeType);
        this.uuid = uuid;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Association(Association a) {
        this.uuid = a.uuid;
        this.linkName = a.linkName;
        this.toConcept = a.toConcept;
        this.linkValue = a.linkValue;
        this.mimeType = a.mimeType;
    }

    public Association(UUID uuid, Association a) {
        this.uuid = uuid;
        this.linkName = a.linkName;
        this.toConcept = a.toConcept;
        this.linkValue = a.linkValue;
        this.mimeType = a.mimeType;
    }

    public static Association fromDetails(Details d) {
        return new Association(d.getLinkName(), d.getToConcept(), d.getLinkValue());
    }

    public void resetUuid() {
        this.uuid = null;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getLinkName() {
        return this.linkName;
    }

    @Override
    public String getToConcept() {
        return this.toConcept;
    }

    @Override
    public String getLinkValue() {
        return this.linkValue;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String toString() {
        return this.linkName + " | " + this.toConcept + " | " + this.linkValue;
    }

    public static Optional<Association> parse(String s) {
        Optional<Association> a = Optional.empty();
        try {
            List<String> ss = Arrays.stream(s.split("[|]")).map(String::trim).toList();
            if (ss.size() == 3) {
                a = Optional.of(new Association(ss.get(0), ss.get(1), ss.get(2)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a;
    }
}

