/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.r1.models;

import com.google.gson.annotations.SerializedName;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.mbari.vars.annosaurus.sdk.r1.models.ImageReference;
import org.mbari.vars.annosaurus.sdk.r1.models.ImagedMoment;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.time.Timecode;

public class Image
implements ImagedMoment,
Cloneable {
    private UUID imageReferenceUuid;
    private String format;
    @SerializedName(value="width_pixels")
    private Integer width;
    @SerializedName(value="height_pixels")
    private Integer height;
    private URL url;
    private String description;
    private UUID videoReferenceUuid;
    private UUID imagedMomentUuid;
    private Timecode timecode;
    @SerializedName(value="elapsed_time_millis")
    private Duration elapsedTime;
    private Instant recordedTimestamp;

    public Image() {
    }

    public Image(ImagedMoment im, ImageReference ir) {
        this.imageReferenceUuid = ir.getUuid();
        this.format = ir.getFormat();
        this.url = ir.getUrl();
        this.description = ir.getDescription();
        this.videoReferenceUuid = im.getVideoReferenceUuid();
        this.imagedMomentUuid = im.getImagedMomentUuid();
        this.timecode = im.getTimecode();
        this.elapsedTime = im.getElapsedTime();
        this.recordedTimestamp = im.getRecordedTimestamp();
    }

    public Image(Image i) {
        this.imageReferenceUuid = i.getImageReferenceUuid();
        this.format = i.getFormat();
        this.width = i.getWidth();
        this.height = i.getHeight();
        this.url = i.getUrl();
        this.description = i.getDescription();
        this.videoReferenceUuid = i.getVideoReferenceUuid();
        this.imagedMomentUuid = i.getImagedMomentUuid();
        this.timecode = i.getTimecode();
        this.elapsedTime = i.getElapsedTime();
        this.recordedTimestamp = i.getRecordedTimestamp();
    }

    public UUID getImageReferenceUuid() {
        return this.imageReferenceUuid;
    }

    public String getFormat() {
        return this.format;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public UUID getVideoReferenceUuid() {
        return this.videoReferenceUuid;
    }

    @Override
    public UUID getImagedMomentUuid() {
        return this.imagedMomentUuid;
    }

    @Override
    public Timecode getTimecode() {
        return this.timecode;
    }

    @Override
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public Instant getRecordedTimestamp() {
        return this.recordedTimestamp;
    }

    public void setImageReferenceUuid(UUID imageReferenceUuid) {
        this.imageReferenceUuid = imageReferenceUuid;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setVideoReferenceUuid(UUID videoReferenceUuid) {
        this.videoReferenceUuid = videoReferenceUuid;
    }

    @Override
    public void setImagedMomentUuid(UUID imagedMomentUuid) {
        this.imagedMomentUuid = imagedMomentUuid;
    }

    @Override
    public void setTimecode(Timecode timecode) {
        this.timecode = timecode;
    }

    @Override
    public void setElapsedTime(Duration elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    @Override
    public void setRecordedTimestamp(Instant recordedTimestamp) {
        this.recordedTimestamp = recordedTimestamp;
    }

    public VideoIndex getVideoIndex() {
        return new VideoIndex(Optional.ofNullable(this.recordedTimestamp), Optional.ofNullable(this.elapsedTime), Optional.ofNullable(this.timecode));
    }

    public String toString() {
        return "Image{imageReferenceUuid=" + String.valueOf(this.imageReferenceUuid) + ", format='" + this.format + "', width=" + String.valueOf(this.width) + ", height=" + String.valueOf(this.height) + ", url=" + String.valueOf(this.url) + ", description='" + this.description + "', videoReferenceUuid=" + String.valueOf(this.videoReferenceUuid) + ", imagedMomentUuid=" + String.valueOf(this.imagedMomentUuid) + ", timecode=" + String.valueOf(this.timecode) + ", elapsedTime=" + String.valueOf(this.elapsedTime) + ", recordedTimestamp=" + String.valueOf(this.recordedTimestamp) + "}";
    }
}

