/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.r1;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.mbari.vars.annosaurus.sdk.kiota.models.DeleteCountSC;
import org.mbari.vars.annosaurus.sdk.r1.AnnotationService;
import org.mbari.vars.annosaurus.sdk.r1.BaseHttpClient;
import org.mbari.vars.annosaurus.sdk.r1.JwtHttpClient;
import org.mbari.vars.annosaurus.sdk.r1.VideoReferenceService;
import org.mbari.vars.annosaurus.sdk.r1.etc.gson.AnnotationCreator;
import org.mbari.vars.annosaurus.sdk.r1.etc.gson.DurationConverter;
import org.mbari.vars.annosaurus.sdk.r1.etc.gson.InstantConverter;
import org.mbari.vars.annosaurus.sdk.r1.etc.gson.TimecodeConverter;
import org.mbari.vars.annosaurus.sdk.r1.etc.jdk.Instants;
import org.mbari.vars.annosaurus.sdk.r1.etc.jdk.Maps;
import org.mbari.vars.annosaurus.sdk.r1.models.AncillaryData;
import org.mbari.vars.annosaurus.sdk.r1.models.AncillaryDataDeleteCount;
import org.mbari.vars.annosaurus.sdk.r1.models.Annotation;
import org.mbari.vars.annosaurus.sdk.r1.models.AnnotationCount;
import org.mbari.vars.annosaurus.sdk.r1.models.Association;
import org.mbari.vars.annosaurus.sdk.r1.models.AssociationCreate;
import org.mbari.vars.annosaurus.sdk.r1.models.Authorization;
import org.mbari.vars.annosaurus.sdk.r1.models.CachedVideoReference;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptAssociationRequest;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptAssociationResponse;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptCount;
import org.mbari.vars.annosaurus.sdk.r1.models.ConceptsRenamed;
import org.mbari.vars.annosaurus.sdk.r1.models.ConcurrentRequest;
import org.mbari.vars.annosaurus.sdk.r1.models.ConcurrentRequestCount;
import org.mbari.vars.annosaurus.sdk.r1.models.Count;
import org.mbari.vars.annosaurus.sdk.r1.models.DeleteCount;
import org.mbari.vars.annosaurus.sdk.r1.models.Image;
import org.mbari.vars.annosaurus.sdk.r1.models.ImagedMoment;
import org.mbari.vars.annosaurus.sdk.r1.models.Index;
import org.mbari.vars.annosaurus.sdk.r1.models.MultiRequest;
import org.mbari.vars.annosaurus.sdk.r1.models.MultiRequestCount;
import org.mbari.vars.annosaurus.sdk.r1.models.ObservationsUpdate;
import org.mbari.vcr4j.time.Timecode;

public class AnnosaurusHttpClient
extends BaseHttpClient
implements AnnotationService,
VideoReferenceService {
    private final JwtHttpClient jwtHttpClient;
    private final Gson gson = AnnosaurusHttpClient.newGson();
    private final Type TYPE_LIST_ANCILLARY_DATA = new TypeToken<ArrayList<AncillaryData>>(){}.getType();
    private final Type TYPE_LIST_ANNOTATION = new TypeToken<ArrayList<Annotation>>(){}.getType();
    private final Type TYPE_LIST_ANNOTATION_COUNT = new TypeToken<ArrayList<AnnotationCount>>(){}.getType();
    private final Type TYPE_LIST_ASSOCIATION = new TypeToken<ArrayList<Association>>(){}.getType();
    private final Type TYPE_LIST_IMAGE = new TypeToken<ArrayList<Image>>(){}.getType();
    private final Type TYPE_LIST_IMAGED_MOMENT = new TypeToken<ArrayList<ImagedMoment>>(){}.getType();
    private final Type TYPE_LIST_INDEX = new TypeToken<ArrayList<Index>>(){}.getType();
    private final Type TYPE_LIST_STRING = new TypeToken<ArrayList<String>>(){}.getType();
    private final Type TYPE_LIST_UUID = new TypeToken<ArrayList<UUID>>(){}.getType();

    public AnnosaurusHttpClient(HttpClient client, URI baseUri, String apiKey) {
        super(client, baseUri);
        this.jwtHttpClient = new JwtHttpClient(client, this.buildUri("/auth"), "Authorization", "APIKEY " + apiKey, body -> (Authorization)this.gson.fromJson(body, Authorization.class));
    }

    public AnnosaurusHttpClient(String baseUri, Duration timeout, String apikey) {
        this(AnnosaurusHttpClient.newHttpClient(timeout), URI.create(baseUri), apikey);
    }

    private Authorization authorizeIfNeeded() {
        return this.jwtHttpClient.authorizeIfNeeded();
    }

    public static Gson newGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(ImagedMoment.class, (Object)new AnnotationCreator()).registerTypeAdapter(Duration.class, (Object)new DurationConverter()).registerTypeAdapter(Timecode.class, (Object)new TimecodeConverter()).registerTypeAdapter(Instant.class, (Object)new InstantConverter());
        return gsonBuilder.create();
    }

    @Override
    public CompletableFuture<Annotation> createAnnotation(Annotation annotation) {
        String json = this.gson.toJson((Object)annotation);
        URI uri = this.buildUri("/annotations");
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Annotation)this.gson.fromJson(body, Annotation.class));
    }

    @Override
    public CompletableFuture<AnnotationCount> countAnnotations(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/observations/videoreference/count/" + String.valueOf(videoReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (AnnotationCount)this.gson.fromJson(body, AnnotationCount.class), new AnnotationCount(videoReferenceUuid, 0));
    }

    @Override
    public CompletableFuture<List<AnnotationCount>> countAnnotationsGroupByVideoReferenceUuid() {
        URI uri = this.buildUri("/observations/counts");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION_COUNT));
    }

    @Override
    public CompletableFuture<ConcurrentRequestCount> countByConcurrentRequest(ConcurrentRequest concurrentRequest) {
        URI uri = this.buildUri("/annotations/concurrent/count");
        String json = this.gson.toJson((Object)concurrentRequest);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (ConcurrentRequestCount)this.gson.fromJson(body, ConcurrentRequestCount.class));
    }

    @Override
    public CompletableFuture<MultiRequestCount> countByMultiRequest(MultiRequest multiRequest) {
        URI uri = this.buildUri("/annotations/multi/count");
        String json = this.gson.toJson((Object)multiRequest);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (MultiRequestCount)this.gson.fromJson(body, MultiRequestCount.class));
    }

    @Override
    public CompletableFuture<List<AnnotationCount>> countImagedMomentsGroupByVideoReferenceUuid() {
        URI uri = this.buildUri("/imagedmoments/counts");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION_COUNT));
    }

    @Override
    public CompletableFuture<ConceptCount> countObservationsByConcept(String concept) {
        String encodedConcept = concept.trim().replaceAll(" ", "%20");
        URI uri = this.buildUri("/observations/concept/count/" + encodedConcept);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (ConceptCount)this.gson.fromJson(body, ConceptCount.class), new ConceptCount(concept, 0));
    }

    @Override
    public CompletableFuture<AnnotationCount> countImagedMomentsModifiedBefore(UUID videoReferenceUuid, Instant date) {
        String t = Instants.COMPACT_TIME_FORMATTER_MS.format(date);
        URI uri = this.buildUri("/imagedmoments/videoreference/modified/" + String.valueOf(videoReferenceUuid) + "/" + t);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (AnnotationCount)this.gson.fromJson(body, AnnotationCount.class), new AnnotationCount(videoReferenceUuid, 0));
    }

    @Override
    public CompletableFuture<Collection<Annotation>> createAnnotations(Collection<Annotation> annotations) {
        URI uri = this.buildUri("/annotations/bulk");
        String json = this.gson.toJson(annotations);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Collection)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION));
    }

    @Override
    public CompletableFuture<Association> createAssociation(UUID observationUuid, Association association) {
        URI uri = this.buildUri("/associations");
        AssociationCreate ac = new AssociationCreate(observationUuid, association);
        String json = this.gson.toJson((Object)ac);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Association)this.gson.fromJson(body, Association.class));
    }

    @Override
    public CompletableFuture<Association> createAssociation(UUID observationUuid, Association association, UUID associationUuid) {
        URI uri = this.buildUri("/associations");
        AssociationCreate dto = new AssociationCreate(observationUuid, association);
        String json = this.gson.toJson((Object)dto);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Association)this.gson.fromJson(body, Association.class));
    }

    @Override
    public CompletableFuture<Image> createImage(Image image) {
        URI uri = this.buildUri("/images");
        String json = this.gson.toJson((Object)image);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Image)this.gson.fromJson(body, Image.class));
    }

    @Override
    public CompletableFuture<List<AncillaryData>> createOrUpdateAncillaryData(List<AncillaryData> ancillaryData) {
        URI uri = this.buildUri("/ancillarydata/bulk");
        String json = this.gson.toJson(ancillaryData);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANCILLARY_DATA));
    }

    @Override
    public CompletableFuture<CachedVideoReference> createCachedVideoReference(CachedVideoReference cvr) {
        URI uri = this.buildUri("/videoreferences");
        String json = this.gson.toJson((Object)cvr);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (CachedVideoReference)this.gson.fromJson(body, CachedVideoReference.class));
    }

    @Override
    public CompletableFuture<AncillaryDataDeleteCount> deleteAncillaryDataByVideoReference(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/ancillarydata/videoreference/" + String.valueOf(videoReferenceUuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Accept", "application/json").DELETE().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (AncillaryDataDeleteCount)this.gson.fromJson(body, AncillaryDataDeleteCount.class));
    }

    @Override
    public CompletableFuture<Boolean> deleteAnnotation(UUID observationUuid) {
        URI uri = this.buildUri("/observations/" + String.valueOf(observationUuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).DELETE().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 204).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> deleteAnnotations(Collection<UUID> observationUuids) {
        URI uri = this.buildUri("/observations/delete");
        String json = this.gson.toJson(observationUuids);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 204).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<DeleteCount> deleteAnnotationsByVideoReferenceUuid(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/fast/videoreference/" + String.valueOf(videoReferenceUuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Accept", "application/json").DELETE().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (DeleteCountSC)this.gson.fromJson(body, DeleteCountSC.class)).thenApply(DeleteCount::fromKiota);
    }

    @Override
    public CompletableFuture<Boolean> deleteAssociation(UUID associationUuid) {
        URI uri = this.buildUri("/associations/" + String.valueOf(associationUuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).DELETE().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 204).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> deleteAssociations(Collection<UUID> associationUuids) {
        URI uri = this.buildUri("/associations/delete");
        String json = this.gson.toJson(associationUuids);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 204).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> deleteImage(UUID imageReferenceUuid) {
        URI uri = this.buildUri("/imagereferences/" + String.valueOf(imageReferenceUuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).DELETE().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 204).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Annotation> deleteDuration(UUID observationUuid) {
        URI uri = this.buildUri("/observations/delete/duration/" + String.valueOf(observationUuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.noBody()).build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (Annotation)this.gson.fromJson(body, Annotation.class));
    }

    @Override
    public CompletableFuture<Boolean> deleteCacheVideoReference(UUID uuid) {
        URI uri = this.buildUri("/videoreferences/" + String.valueOf(uuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).DELETE().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 204).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<List<String>> findActivities() {
        URI uri = this.buildUri("/observations/activities");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_STRING));
    }

    @Override
    public CompletableFuture<List<UUID>> findAllVideoReferenceUuids() {
        URI uri = this.buildUri("/imagedmoments/videoreference");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_UUID));
    }

    @Override
    public CompletableFuture<AncillaryData> findAncillaryData(UUID observationUuid) {
        URI uri = this.buildUri("/ancillarydata/observation/" + String.valueOf(observationUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (AncillaryData)this.gson.fromJson(body, AncillaryData.class), null);
    }

    @Override
    public CompletableFuture<List<AncillaryData>> findAncillaryDataByVideoReference(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/ancillarydata/videoreference/" + String.valueOf(videoReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANCILLARY_DATA), new ArrayList());
    }

    @Override
    public CompletableFuture<List<Annotation>> findByConcept(String concept, Boolean data) {
        String query = Maps.mapToQueryFragment(Map.of("data", data));
        URI uri = this.buildUri("/fast/concept/" + concept + query);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION), new ArrayList());
    }

    @Override
    public CompletableFuture<List<Annotation>> findByConcept(String concept, Long limit, Long offset, Boolean data) {
        Map<String, Object> queryMap = Maps.of("limit", limit, "offset", offset, "data", data);
        String query = Maps.mapToQueryFragment(queryMap);
        URI uri = this.buildUri("/fast/concept/" + concept + query);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION), new ArrayList());
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid) {
        return this.findAnnotations(videoReferenceUuid, null, null, false);
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid, boolean data) {
        return this.findAnnotations(videoReferenceUuid, null, null, data);
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid, Long limit, Long offset) {
        return this.findAnnotations(videoReferenceUuid, limit, offset, false);
    }

    @Override
    public CompletableFuture<List<Annotation>> findAnnotations(UUID videoReferenceUuid, Long limit, Long offset, Boolean data) {
        Map<String, Object> queryMap = Maps.of("limit", limit, "offset", offset, "data", data);
        String query = Maps.mapToQueryFragment(queryMap);
        URI uri = this.buildUri("/fast/videoreference/" + String.valueOf(videoReferenceUuid) + query);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION), new ArrayList());
    }

    @Override
    public CompletableFuture<Association> findAssociationByUuid(UUID associationUuid) {
        URI uri = this.buildUri("/associations/" + String.valueOf(associationUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (Association)this.gson.fromJson(body, Association.class), null);
    }

    @Override
    public CompletableFuture<ConceptAssociationResponse> findByConceptAssociationRequest(ConceptAssociationRequest request) {
        URI uri = this.buildUri("/associations/conceptassociations");
        String json = this.gson.toJson((Object)request);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(httpRequest, json);
        return this.submit(httpRequest, 200, body -> (ConceptAssociationResponse)this.gson.fromJson(body, ConceptAssociationResponse.class));
    }

    @Override
    public CompletableFuture<List<Annotation>> findByConcurrentRequest(ConcurrentRequest concurrentRequest, long limit, long offset) {
        Map<String, Object> queryMap = Maps.of("limit", limit, "offset", offset);
        String query = Maps.mapToQueryFragment(queryMap);
        URI uri = this.buildUri("/fast/concurrent" + query);
        String json = this.gson.toJson((Object)concurrentRequest);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION));
    }

    @Override
    public CompletableFuture<List<Annotation>> findByImageReference(UUID imageReferenceUuid) {
        URI uri = this.buildUri("/annotations/imagereference/" + String.valueOf(imageReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION), new ArrayList());
    }

    @Override
    public CompletableFuture<List<Annotation>> findByMultiRequest(MultiRequest multiRequest, long limit, long offset) {
        Map<String, Object> queryMap = Maps.of("limit", limit, "offset", offset);
        String query = Maps.mapToQueryFragment(queryMap);
        URI uri = this.buildUri("/fast/multi" + query);
        String json = this.gson.toJson((Object)multiRequest);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION), new ArrayList());
    }

    @Override
    public CompletableFuture<Annotation> findByUuid(UUID observationUuid) {
        URI uri = this.buildUri("/annotations/" + String.valueOf(observationUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (Annotation)this.gson.fromJson(body, Annotation.class), null);
    }

    @Override
    public CompletableFuture<List<Association>> findByVideoReferenceAndLinkName(UUID videoReferenceUuid, String linkName) {
        URI uri = this.buildUri("/associations/" + String.valueOf(videoReferenceUuid) + "/" + linkName);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ASSOCIATION), new ArrayList());
    }

    @Override
    public CompletableFuture<List<Association>> findByVideoReferenceAndLinkNameAndConcept(UUID videoReferenceUuid, String linkName, String concept) {
        URI uri = this.buildUri("/associations/" + String.valueOf(videoReferenceUuid) + "/" + linkName + "?concept=" + concept);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_ASSOCIATION), new ArrayList());
    }

    @Override
    public CompletableFuture<List<String>> findGroups() {
        URI uri = this.buildUri("/observations/groups");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_STRING));
    }

    @Override
    public CompletableFuture<Image> findImageByUrl(URL url) {
        String encodedUrl = URLEncoder.encode(url.toString(), StandardCharsets.UTF_8);
        URI uri = this.buildUri("/images/url/" + encodedUrl);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (Image)this.gson.fromJson(body, Image.class), null);
    }

    @Override
    public CompletableFuture<Image> findImageByUuid(UUID imageReferenceUuid) {
        URI uri = this.buildUri("/images/" + String.valueOf(imageReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        return this.submitSearch(request, 200, body -> (Image)this.gson.fromJson(body, Image.class), null);
    }

    @Override
    public CompletableFuture<List<Image>> findImagesByVideoReferenceUuid(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/fast/images/videoreference/" + String.valueOf(videoReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_IMAGE), new ArrayList());
    }

    @Override
    public CompletableFuture<List<ImagedMoment>> findImagedMomentsByVideoReferenceUuid(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/imagedmoments/videoreference/" + String.valueOf(videoReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_IMAGED_MOMENT), new ArrayList());
    }

    @Override
    public CompletableFuture<List<Index>> findIndicesByVideoReferenceUuid(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/index/videoreference/" + String.valueOf(videoReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_INDEX), new ArrayList());
    }

    @Override
    public CompletableFuture<CachedVideoReference> findVideoReferenceByVideoReferenceUuid(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/videoreferences/videoreference/" + String.valueOf(videoReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (CachedVideoReference)this.gson.fromJson(body, CachedVideoReference.class), null);
    }

    @Override
    public CompletableFuture<Collection<AncillaryData>> merge(UUID videoReferenceUuid, Collection<AncillaryData> data) {
        URI uri = this.buildUri("/ancillarydata/merge/" + String.valueOf(videoReferenceUuid));
        String json = this.gson.toJson(data);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Collection)this.gson.fromJson(body, this.TYPE_LIST_ANCILLARY_DATA));
    }

    @Override
    public CompletableFuture<ConceptsRenamed> renameConcepts(String oldConcept, String newConcept) {
        URI uri = this.buildUri("/observations/concept/rename");
        String json = this.gson.toJson(Map.of("old", oldConcept, "new", newConcept));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (ConceptsRenamed)this.gson.fromJson(body, ConceptsRenamed.class));
    }

    @Override
    public CompletableFuture<Annotation> updateAnnotation(Annotation annotation) {
        URI uri = this.buildUri("/annotations/" + String.valueOf(annotation.getObservationUuid()));
        String json = this.gson.toJson((Object)annotation);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Annotation)this.gson.fromJson(body, Annotation.class));
    }

    @Override
    public CompletableFuture<Collection<Annotation>> updateAnnotations(Collection<Annotation> annotations) {
        URI uri = this.buildUri("/annotations/bulk");
        String json = this.gson.toJson(annotations);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Collection)this.gson.fromJson(body, this.TYPE_LIST_ANNOTATION));
    }

    @Override
    public CompletableFuture<Association> updateAssociation(Association association) {
        URI uri = this.buildUri("/associations/" + String.valueOf(association.getUuid()));
        String json = this.gson.toJson((Object)association);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Association)this.gson.fromJson(body, Association.class));
    }

    @Override
    public CompletableFuture<Collection<Association>> updateAssociations(Collection<Association> associations) {
        URI uri = this.buildUri("/associations/bulk");
        String json = this.gson.toJson(associations);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Collection)this.gson.fromJson(body, this.TYPE_LIST_ASSOCIATION));
    }

    @Override
    public CompletableFuture<Image> updateImage(Image image) {
        URI uri = this.buildUri("/images/" + String.valueOf(image.getImageReferenceUuid()));
        String json = this.gson.toJson((Object)image);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Image)this.gson.fromJson(body, Image.class));
    }

    @Override
    public CompletableFuture<List<Index>> updateIndexRecordedTimestamps(Collection<Index> indices) {
        URI uri = this.buildUri("/index/tapetime");
        String json = this.gson.toJson(indices);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_INDEX));
    }

    @Override
    public CompletableFuture<Count> updateObservations(ObservationsUpdate update) {
        URI uri = this.buildUri("/observations/bulk");
        String json = this.gson.toJson((Object)update);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Count)this.gson.fromJson(body, Count.class));
    }

    @Override
    public CompletableFuture<Collection<Annotation>> updateRecordedTimestampsForTapes(Collection<Annotation> annotations) {
        throw new UnsupportedOperationException("Use updateIndexRecordedTimestamps instead");
    }

    @Override
    public CompletableFuture<Optional<Index>> updateRecordedTimestamp(UUID imagedMomentUuid, Instant recordedTimestamp) {
        Map<String, String> map = Map.of("recorded_timestamp", recordedTimestamp.toString());
        URI uri = this.buildUri("/imagedmoments/" + String.valueOf(imagedMomentUuid));
        String json = this.gson.toJson(map);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (Index)this.gson.fromJson(body, Index.class)).thenApply(Optional::ofNullable);
    }

    @Override
    public CompletableFuture<CachedVideoReference> updateCachedVideoReference(CachedVideoReference cvr) {
        URI uri = this.buildUri("/videoreferences/" + String.valueOf(cvr.getUuid()));
        String json = this.gson.toJson((Object)cvr);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (CachedVideoReference)this.gson.fromJson(body, CachedVideoReference.class));
    }

    @Override
    public CompletableFuture<List<String>> findAllMissionIds() {
        URI uri = this.buildUri("/videoreferences/missionids");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_STRING));
    }

    @Override
    public CompletableFuture<List<String>> findAllMissionContacts() {
        URI uri = this.buildUri("/videoreferences/missioncontacts");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_STRING));
    }

    @Override
    public CompletableFuture<List<UUID>> findAlLVideoReferenceUuids() {
        URI uri = this.buildUri("/videoreferences/videoreferences");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 200, body -> (List)this.gson.fromJson(body, this.TYPE_LIST_UUID));
    }

    @Override
    public CompletableFuture<CachedVideoReference> create(CachedVideoReference videoReference) {
        URI uri = this.buildUri("/videoreferences");
        String json = this.gson.toJson((Object)videoReference);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (CachedVideoReference)this.gson.fromJson(body, CachedVideoReference.class));
    }

    @Override
    public CompletableFuture<CachedVideoReference> update(UUID videoReferenceUuid, CachedVideoReference videoReference) {
        URI uri = this.buildUri("/videoreferences/" + String.valueOf(videoReferenceUuid));
        String json = this.gson.toJson((Object)videoReference);
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).header("Content-Type", "application/json").header("Accept", "application/json").PUT(HttpRequest.BodyPublishers.ofString(json)).build();
        this.debugLog.logRequest(request, json);
        return this.submit(request, 200, body -> (CachedVideoReference)this.gson.fromJson(body, CachedVideoReference.class));
    }

    @Override
    public CompletableFuture<Void> delete(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/videoreferences/" + String.valueOf(videoReferenceUuid));
        Authorization auth = this.authorizeIfNeeded();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "BEARER " + auth.getAccessToken()).DELETE().build();
        this.debugLog.logRequest(request, null);
        return this.submit(request, 204).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<CachedVideoReference> findVideoReferenceByUuid(UUID videoReferenceUuid) {
        URI uri = this.buildUri("/videoreferences/" + String.valueOf(videoReferenceUuid));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").GET().build();
        this.debugLog.logRequest(request, null);
        return this.submitSearch(request, 200, body -> (CachedVideoReference)this.gson.fromJson(body, CachedVideoReference.class), null);
    }
}

