/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.r1;

import com.github.mizosoft.methanol.Methanol;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.mbari.vars.annosaurus.sdk.r1.etc.jdk.Loggers;

public class BaseHttpClient {
    protected final Loggers log = new Loggers(this.getClass());
    protected final Loggers debugLog = this.log.atDebug();
    private final HttpClient client;
    private final URI baseUri;
    protected final ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();

    public BaseHttpClient(HttpClient client, URI baseUri) {
        this.client = client;
        this.baseUri = baseUri;
    }

    public URI buildUri(String path) {
        String newPath = this.baseUri.getPath() + path;
        return this.baseUri.resolve(newPath);
    }

    public static HttpClient newHttpClient(Duration timeout) {
        return ((Methanol.Builder)((Methanol.Builder)((Methanol.Builder)((Methanol.Builder)Methanol.newBuilder().autoAcceptEncoding(true)).connectTimeout(timeout).executor((Executor)Executors.newVirtualThreadPerTaskExecutor()).followRedirects(HttpClient.Redirect.ALWAYS).readTimeout(timeout)).requestTimeout(timeout)).userAgent("org.mbari.vars.services")).build();
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public <T> CompletableFuture<T> submit(HttpRequest request, int okCode, Function<String, T> fn) {
        CompletableFuture future = new CompletableFuture();
        Runnable task = () -> {
            try {
                HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
                this.debugLog.logResponse(response);
                if (response.statusCode() != okCode) {
                    future.completeExceptionally(new RuntimeException("Expected a status code of " + okCode + " but it was " + response.statusCode() + " from " + request.method() + " " + String.valueOf(request.uri())));
                    return;
                }
                if (fn != null) {
                    Object body = fn.apply(response.body());
                    future.complete(body);
                } else {
                    future.complete(null);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        this.executor.execute(task);
        return future;
    }

    public CompletableFuture<Void> submit(HttpRequest request, int okCode) {
        return this.submit(request, okCode, null);
    }

    public <T> CompletableFuture<T> submitSearch(HttpRequest request, int okCode, Function<String, T> fn, T defaultValue) {
        CompletableFuture future = new CompletableFuture();
        Runnable task = () -> {
            try {
                HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
                this.debugLog.logResponse(response);
                if (response.statusCode() == 404) {
                    this.log.atInfo().log(() -> "Not found for " + request.method() + " " + String.valueOf(request.uri()));
                    future.complete(defaultValue);
                } else if (response.statusCode() == okCode) {
                    Object body = fn.apply(response.body());
                    future.complete(body);
                } else {
                    future.completeExceptionally(new RuntimeException("Expected a status code of " + okCode + " but it was " + response.statusCode() + " from " + request.method() + " " + String.valueOf(request.uri())));
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        this.executor.execute(task);
        return future;
    }
}

