package org.mbari.vars.annosaurus.sdk.kiota.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class RenameConcept implements AdditionalDataHolder, Parsable {
    /**
     * Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     */
    private Map<String, Object> additionalData;
    /**
     * The new property
     */
    private String newEscaped;
    /**
     * The old property
     */
    private String old;
    /**
     * Instantiates a new {@link RenameConcept} and sets the default values.
     */
    public RenameConcept() {
        this.setAdditionalData(new HashMap<>());
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link RenameConcept}
     */
    @jakarta.annotation.Nonnull
    public static RenameConcept createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RenameConcept();
    }
    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return a {@link Map<String, Object>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(2);
        deserializerMap.put("new", (n) -> { this.setNew(n.getStringValue()); });
        deserializerMap.put("old", (n) -> { this.setOld(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the new property value. The new property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getNew() {
        return this.newEscaped;
    }
    /**
     * Gets the old property value. The old property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getOld() {
        return this.old;
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("new", this.getNew());
        writer.writeStringValue("old", this.getOld());
        writer.writeAdditionalData(this.getAdditionalData());
    }
    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param value Value to set for the AdditionalData property.
     */
    public void setAdditionalData(@jakarta.annotation.Nullable final Map<String, Object> value) {
        this.additionalData = value;
    }
    /**
     * Sets the new property value. The new property
     * @param value Value to set for the new property.
     */
    public void setNew(@jakarta.annotation.Nullable final String value) {
        this.newEscaped = value;
    }
    /**
     * Sets the old property value. The old property
     * @param value Value to set for the old property.
     */
    public void setOld(@jakarta.annotation.Nullable final String value) {
        this.old = value;
    }
}
