/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.microsoft.kiota.authentication.AccessTokenProvider;
import com.microsoft.kiota.authentication.AllowedHostsValidator;
import com.microsoft.kiota.serialization.JsonParseNodeFactory;
import com.microsoft.kiota.serialization.ParseNode;
import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mbari.vars.annosaurus.sdk.kiota.models.AuthorizationSC;

public class AnnosaurusAccessTokenProvider
implements AccessTokenProvider {
    private static final System.Logger logger = System.getLogger(AnnosaurusAccessTokenProvider.class.getName());
    private final AllowedHostsValidator hostValidator;
    private final URI authUrl;
    private final String apiKey;
    private String token;
    private DecodedJWT jwt;
    private static final JsonParseNodeFactory jsonParseNodeFactory = new JsonParseNodeFactory();

    public AnnosaurusAccessTokenProvider(String authUrl, String apiKey) {
        this.authUrl = URI.create(authUrl);
        Set<String> allowedHosts = Set.of(AnnosaurusAccessTokenProvider.baseUrltoAllowedHost(authUrl));
        this.hostValidator = new AllowedHostsValidator(new String[0]);
        this.hostValidator.setAllowedHosts(allowedHosts);
        this.apiKey = apiKey;
    }

    public static String baseUrltoAllowedHost(String baseUrl) {
        String regex = "^(?://[^:]+://)?([^/?]+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(baseUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new RuntimeException("Invalid URL: " + baseUrl);
    }

    public String doTokenRequest(URI uri) throws Exception {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().post(RequestBody.create((byte[])new byte[0])).url(uri.toURL()).addHeader("Authorization", "ApiKey " + this.apiKey).build();
        logger.log(System.Logger.Level.DEBUG, "Requesting token from " + String.valueOf(uri));
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                InputStream body = response.body().byteStream();
                ParseNode parseNode = jsonParseNodeFactory.getParseNode("application/json", body);
                AuthorizationSC entity = (AuthorizationSC)parseNode.getObjectValue(AuthorizationSC::createFromDiscriminatorValue);
                String string = entity.getAccessToken();
                return string;
            }
        }
        return null;
    }

    public String authorize() {
        if (this.jwt == null || this.isExpired(this.jwt)) {
            try {
                this.token = this.doTokenRequest(this.authUrl);
                this.jwt = JWT.decode((String)this.token);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Failed to authorize", (Throwable)e);
                return "";
            }
        }
        return this.token;
    }

    private boolean isExpired(DecodedJWT jwt) {
        try {
            Instant iat = jwt.getExpiresAt().toInstant();
            return iat.isBefore(Instant.now());
        }
        catch (Exception e) {
            return true;
        }
    }

    @NotNull
    public String getAuthorizationToken(@NotNull URI uri, @Nullable Map<String, Object> additionalAuthenticationContext) {
        return this.authorize();
    }

    @NotNull
    public AllowedHostsValidator getAllowedHostsValidator() {
        return this.hostValidator;
    }
}

