/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.ancillarydata;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.CachedAncillaryDatumSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.models.Unauthorized;
import org.mbari.vars.annosaurus.sdk.kiota.v1.ancillarydata.bulk.BulkRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.ancillarydata.imagedmoment.ImagedmomentRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.ancillarydata.item.WithAncillaryDataUuItemRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.ancillarydata.merge.MergeRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.ancillarydata.observation.ObservationRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.ancillarydata.videoreference.VideoreferenceRequestBuilder;

public class AncillarydataRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public BulkRequestBuilder bulk() {
        return new BulkRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ImagedmomentRequestBuilder imagedmoment() {
        return new ImagedmomentRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MergeRequestBuilder merge() {
        return new MergeRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ObservationRequestBuilder observation() {
        return new ObservationRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VideoreferenceRequestBuilder videoreference() {
        return new VideoreferenceRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WithAncillaryDataUuItemRequestBuilder byAncillaryDataUuid(@Nonnull UUID ancillaryDataUuid) {
        Objects.requireNonNull(ancillaryDataUuid);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("ancillaryDataUuid", ancillaryDataUuid);
        return new WithAncillaryDataUuItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public AncillarydataRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/ancillarydata", pathParameters);
    }

    public AncillarydataRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/ancillarydata", rawUrl);
    }

    @Nullable
    public CachedAncillaryDatumSC post(@Nonnull CachedAncillaryDatumSC body) {
        return this.post(body, null);
    }

    @Nullable
    public CachedAncillaryDatumSC post(@Nonnull CachedAncillaryDatumSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return (CachedAncillaryDatumSC)this.requestAdapter.send(requestInfo, errorMapping, CachedAncillaryDatumSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull CachedAncillaryDatumSC body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull CachedAncillaryDatumSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration(this));
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public AncillarydataRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new AncillarydataRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
        public PostRequestConfiguration(AncillarydataRequestBuilder this$0) {
        }
    }
}

