/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.annotations.bulk;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.AnnotationSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.AnnotationUpdateSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.BulkAnnotationSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.models.Unauthorized;

public class BulkRequestBuilder
extends BaseRequestBuilder {
    public BulkRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/annotations/bulk", pathParameters);
    }

    public BulkRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/annotations/bulk", rawUrl);
    }

    @Nullable
    public List<AnnotationSC> post(@Nonnull List<BulkAnnotationSC> body) {
        return this.post(body, null);
    }

    @Nullable
    public List<AnnotationSC> post(@Nonnull List<BulkAnnotationSC> body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return this.requestAdapter.sendCollection(requestInfo, errorMapping, AnnotationSC::createFromDiscriminatorValue);
    }

    @Nullable
    public List<AnnotationSC> put(@Nonnull List<AnnotationUpdateSC> body) {
        return this.put(body, null);
    }

    @Nullable
    public List<AnnotationSC> put(@Nonnull List<AnnotationUpdateSC> body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPutRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return this.requestAdapter.sendCollection(requestInfo, errorMapping, AnnotationSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull List<BulkAnnotationSC> body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull List<BulkAnnotationSC> body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration(this));
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable[])body.toArray(new BulkAnnotationSC[0]));
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull List<AnnotationUpdateSC> body) {
        return this.toPutRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull List<AnnotationUpdateSC> body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PUT, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PutRequestConfiguration(this));
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable[])body.toArray(new AnnotationUpdateSC[0]));
        return requestInfo;
    }

    @Nonnull
    public BulkRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new BulkRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PutRequestConfiguration
    extends BaseRequestConfiguration {
        public PutRequestConfiguration(BulkRequestBuilder this$0) {
        }
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
        public PostRequestConfiguration(BulkRequestBuilder this$0) {
        }
    }
}

