/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.videoreferences;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.CachedVideoReferenceInfoCreateSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.CachedVideoReferenceInfoSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.models.Unauthorized;
import org.mbari.vars.annosaurus.sdk.kiota.v1.videoreferences.item.WithVideoInfoUuItemRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.videoreferences.missioncontact.MissioncontactRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.videoreferences.missioncontacts.MissioncontactsRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.videoreferences.missionid.MissionidRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.videoreferences.missionids.MissionidsRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.videoreferences.videoreference.VideoreferenceRequestBuilder;

public class VideoreferencesRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public MissioncontactRequestBuilder missioncontact() {
        return new MissioncontactRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MissioncontactsRequestBuilder missioncontacts() {
        return new MissioncontactsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MissionidRequestBuilder missionid() {
        return new MissionidRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MissionidsRequestBuilder missionids() {
        return new MissionidsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VideoreferenceRequestBuilder videoreference() {
        return new VideoreferenceRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VideoreferencesRequestBuilder videoreferences() {
        return new VideoreferencesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WithVideoInfoUuItemRequestBuilder byVideoInfoUuid(@Nonnull UUID videoInfoUuid) {
        Objects.requireNonNull(videoInfoUuid);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("videoInfoUuid", videoInfoUuid);
        return new WithVideoInfoUuItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public VideoreferencesRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/videoreferences{?limit*,offset*}", pathParameters);
    }

    public VideoreferencesRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/videoreferences{?limit*,offset*}", rawUrl);
    }

    @Nullable
    public List<CachedVideoReferenceInfoSC> get() {
        return this.get(null);
    }

    @Nullable
    public List<CachedVideoReferenceInfoSC> get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return this.requestAdapter.sendCollection(requestInfo, errorMapping, CachedVideoReferenceInfoSC::createFromDiscriminatorValue);
    }

    @Nullable
    public CachedVideoReferenceInfoSC post(@Nonnull CachedVideoReferenceInfoCreateSC body) {
        return this.post(body, null);
    }

    @Nullable
    public CachedVideoReferenceInfoSC post(@Nonnull CachedVideoReferenceInfoCreateSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return (CachedVideoReferenceInfoSC)this.requestAdapter.send(requestInfo, errorMapping, CachedVideoReferenceInfoSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull CachedVideoReferenceInfoCreateSC body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull CachedVideoReferenceInfoCreateSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration(this));
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public VideoreferencesRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new VideoreferencesRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
        public PostRequestConfiguration(VideoreferencesRequestBuilder this$0) {
        }
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters(VideoreferencesRequestBuilder.this);
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Integer limit;
        @Nullable
        public Integer offset;

        public GetQueryParameters(VideoreferencesRequestBuilder this$0) {
        }

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("offset", this.offset);
            return allQueryParams;
        }
    }
}

