/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk;

import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.authentication.AccessTokenProvider;
import com.microsoft.kiota.authentication.AnonymousAuthenticationProvider;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import com.microsoft.kiota.authentication.BaseBearerTokenAuthenticationProvider;
import com.microsoft.kiota.http.KiotaClientFactory;
import com.microsoft.kiota.http.OkHttpRequestAdapter;
import java.util.Arrays;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.mbari.vars.annosaurus.sdk.AnnosaurusAccessTokenProvider;
import org.mbari.vars.annosaurus.sdk.kiota.Annosaurus;

public class AnnosaurusFactory {
    private static final System.Logger log = System.getLogger(AnnosaurusFactory.class.getName());

    public static Annosaurus create(String baseUrl, String apiKey) {
        AnnosaurusAccessTokenProvider tokenProvider = new AnnosaurusAccessTokenProvider(baseUrl + "/v1/auth", apiKey);
        BaseBearerTokenAuthenticationProvider authProvider = new BaseBearerTokenAuthenticationProvider((AccessTokenProvider)tokenProvider);
        Interceptor[] interceptors = KiotaClientFactory.createDefaultInterceptors();
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "Creating new Annosaurus instance with base URL: " + baseUrl);
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(s -> log.log(System.Logger.Level.DEBUG, s));
            loggingInterceptor.redactHeader("Authorization");
            interceptors = Arrays.copyOf(interceptors, interceptors.length + 1);
            interceptors[interceptors.length - 1] = loggingInterceptor;
        }
        OkHttpClient client = KiotaClientFactory.create((Interceptor[])interceptors).build();
        OkHttpRequestAdapter adapter = new OkHttpRequestAdapter((AuthenticationProvider)authProvider, null, null, (Call.Factory)client);
        adapter.setBaseUrl(baseUrl);
        return new Annosaurus((RequestAdapter)adapter);
    }

    public static Annosaurus create(String baseUrl) {
        AnonymousAuthenticationProvider authProvider = new AnonymousAuthenticationProvider();
        Interceptor[] interceptors = KiotaClientFactory.createDefaultInterceptors();
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "Creating new Annosaurus instance with base URL: " + baseUrl);
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(s -> log.log(System.Logger.Level.DEBUG, s));
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            interceptors = Arrays.copyOf(interceptors, interceptors.length + 1);
            interceptors[interceptors.length - 1] = loggingInterceptor;
        }
        OkHttpClient client = KiotaClientFactory.create((Interceptor[])interceptors).build();
        OkHttpRequestAdapter adapter = new OkHttpRequestAdapter((AuthenticationProvider)authProvider, null, null, (Call.Factory)client);
        adapter.setBaseUrl(baseUrl);
        return new Annosaurus((RequestAdapter)adapter);
    }
}

