/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.annotations;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.AnnotationCreateSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.AnnotationSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.models.Unauthorized;
import org.mbari.vars.annosaurus.sdk.kiota.v1.annotations.bulk.BulkRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.annotations.concurrent.ConcurrentRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.annotations.imagereference.ImagereferenceRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.annotations.item.WithObservationUuItemRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.annotations.multi.MultiRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.annotations.videoreference.VideoreferenceRequestBuilder;

public class AnnotationsRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public BulkRequestBuilder bulk() {
        return new BulkRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ConcurrentRequestBuilder concurrent() {
        return new ConcurrentRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ImagereferenceRequestBuilder imagereference() {
        return new ImagereferenceRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MultiRequestBuilder multi() {
        return new MultiRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VideoreferenceRequestBuilder videoreference() {
        return new VideoreferenceRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WithObservationUuItemRequestBuilder byObservationUuid(@Nonnull UUID observationUuid) {
        Objects.requireNonNull(observationUuid);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("observationUuid", observationUuid);
        return new WithObservationUuItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public AnnotationsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/annotations", pathParameters);
    }

    public AnnotationsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/annotations", rawUrl);
    }

    @Nullable
    public AnnotationSC post(@Nonnull AnnotationCreateSC body) {
        return this.post(body, null);
    }

    @Nullable
    public AnnotationSC post(@Nonnull AnnotationCreateSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("401", Unauthorized::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return (AnnotationSC)this.requestAdapter.send(requestInfo, errorMapping, AnnotationSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull AnnotationCreateSC body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull AnnotationCreateSC body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public AnnotationsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new AnnotationsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

