/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.kiota.v1.fast;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.mbari.vars.annosaurus.sdk.kiota.models.AnnotationSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.BadRequest;
import org.mbari.vars.annosaurus.sdk.kiota.models.NotFound;
import org.mbari.vars.annosaurus.sdk.kiota.models.QueryConstraints;
import org.mbari.vars.annosaurus.sdk.kiota.models.QueryConstraintsResponseSCSeqAnnotationSC;
import org.mbari.vars.annosaurus.sdk.kiota.models.ServerError;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.concept.ConceptRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.concurrent.ConcurrentRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.count.CountRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.details.DetailsRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.georange.GeorangeRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.imagedmoments.ImagedmomentsRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.images.ImagesRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.multi.MultiRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.toconcept.ToconceptRequestBuilder;
import org.mbari.vars.annosaurus.sdk.kiota.v1.fast.videoreference.VideoreferenceRequestBuilder;

public class FastRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ConceptRequestBuilder concept() {
        return new ConceptRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ConcurrentRequestBuilder concurrent() {
        return new ConcurrentRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CountRequestBuilder count() {
        return new CountRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DetailsRequestBuilder details() {
        return new DetailsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GeorangeRequestBuilder georange() {
        return new GeorangeRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ImagedmomentsRequestBuilder imagedmoments() {
        return new ImagedmomentsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ImagesRequestBuilder images() {
        return new ImagesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MultiRequestBuilder multi() {
        return new MultiRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ToconceptRequestBuilder toconcept() {
        return new ToconceptRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VideoreferenceRequestBuilder videoreference() {
        return new VideoreferenceRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public FastRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/fast{?data*,limit*,offset*}", pathParameters);
    }

    public FastRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/v1/fast{?data*,limit*,offset*}", rawUrl);
    }

    @Nullable
    public List<AnnotationSC> get() {
        return this.get(null);
    }

    @Nullable
    public List<AnnotationSC> get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return this.requestAdapter.sendCollection(requestInfo, errorMapping, AnnotationSC::createFromDiscriminatorValue);
    }

    @Nullable
    public QueryConstraintsResponseSCSeqAnnotationSC post(@Nonnull QueryConstraints body) {
        return this.post(body, null);
    }

    @Nullable
    public QueryConstraintsResponseSCSeqAnnotationSC post(@Nonnull QueryConstraints body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", BadRequest::createFromDiscriminatorValue);
        errorMapping.put("404", NotFound::createFromDiscriminatorValue);
        errorMapping.put("500", ServerError::createFromDiscriminatorValue);
        return (QueryConstraintsResponseSCSeqAnnotationSC)this.requestAdapter.send(requestInfo, errorMapping, QueryConstraintsResponseSCSeqAnnotationSC::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull QueryConstraints body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull QueryConstraints body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public FastRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new FastRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Boolean data;
        @Nullable
        public Integer limit;
        @Nullable
        public Integer offset;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("data", this.data);
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("offset", this.offset);
            return allQueryParams;
        }
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

