/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.r1.etc.jdk;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public record Loggers(System.Logger logger, System.Logger.Level level, Throwable cause) {
    public Loggers(System.Logger logger) {
        this(logger, System.Logger.Level.OFF, null);
    }

    public Loggers(String loggerName) {
        this(System.getLogger(loggerName), System.Logger.Level.OFF, null);
    }

    public Loggers(Class<?> clazz) {
        this(clazz.getName());
    }

    public Loggers atTrace() {
        return new Loggers(this.logger, System.Logger.Level.TRACE, this.cause);
    }

    public Loggers atDebug() {
        return new Loggers(this.logger, System.Logger.Level.DEBUG, this.cause);
    }

    public Loggers atInfo() {
        return new Loggers(this.logger, System.Logger.Level.INFO, this.cause);
    }

    public Loggers atWarn() {
        return new Loggers(this.logger, System.Logger.Level.WARNING, this.cause);
    }

    public Loggers atError() {
        return new Loggers(this.logger, System.Logger.Level.ERROR, this.cause);
    }

    public Loggers withCause(Throwable t) {
        return new Loggers(this.logger, this.level, t);
    }

    public void log(String msg) {
        if (this.logger.isLoggable(this.level)) {
            if (this.cause == null) {
                this.logger.log(this.level, msg);
            } else {
                this.logger.log(this.level, msg, this.cause);
            }
        }
    }

    public void log(Supplier<String> fn) {
        if (this.logger.isLoggable(this.level)) {
            if (this.cause == null) {
                this.logger.log(this.level, fn);
            } else {
                this.logger.log(this.level, fn, this.cause);
            }
        }
    }

    public void logResponse(HttpResponse<?> response) {
        if (this.logger.isLoggable(this.level)) {
            HttpRequest req = response.request();
            String headers = response.headers().map().entrySet().stream().map(e -> (String)e.getKey() + ": " + String.join((CharSequence)", ", (Iterable)e.getValue())).collect(Collectors.joining(System.lineSeparator()));
            this.log(() -> "RESPONSE: " + req.method() + " " + String.valueOf(req.uri()) + " [" + response.statusCode() + "] \n" + headers + "\n\n" + String.valueOf(response.body()));
        }
    }

    public void logRequest(HttpRequest request, String body) {
        if (this.logger.isLoggable(this.level)) {
            String headers = request.headers().map().entrySet().stream().map(e -> (String)e.getKey() + ": " + String.join((CharSequence)", ", (Iterable)e.getValue())).collect(Collectors.joining(System.lineSeparator()));
            Object bodyString = body == null ? "" : "\n\n" + body;
            this.log(() -> Loggers.lambda$3(request, headers, (String)bodyString));
        }
    }

    private static /* synthetic */ String lambda$3(HttpRequest httpRequest, String string, String string2) {
        return "REQUEST: " + httpRequest.method() + " " + String.valueOf(httpRequest.uri()) + "\n" + string + string2;
    }
}

