/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.annosaurus.sdk.r1.models;

import com.google.gson.annotations.SerializedName;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.mbari.vars.annosaurus.sdk.r1.models.AncillaryData;
import org.mbari.vars.annosaurus.sdk.r1.models.Association;
import org.mbari.vars.annosaurus.sdk.r1.models.ImageReference;
import org.mbari.vars.annosaurus.sdk.r1.models.ImagedMoment;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.time.Timecode;

public class Annotation
implements ImagedMoment {
    private UUID observationUuid;
    private String concept;
    private String observer;
    private Instant observationTimestamp;
    private UUID videoReferenceUuid;
    private UUID imagedMomentUuid;
    private Timecode timecode;
    @SerializedName(value="elapsed_time_millis")
    private Duration elapsedTime;
    private Instant recordedTimestamp;
    @SerializedName(value="duration_millis")
    private Duration duration;
    private String group;
    private String activity;
    private List<Association> associations;
    private List<ImageReference> imageReferences;
    private AncillaryData ancillaryData;
    private transient Object transientKey;

    public Annotation() {
    }

    public Annotation(String concept, String observer) {
        this.concept = concept;
        this.observer = observer;
        this.observationTimestamp = Instant.now();
    }

    public Annotation(String concept, String observer, VideoIndex videoIndex, UUID videoReferenceUuid) {
        this.concept = concept;
        this.observer = observer;
        this.observationTimestamp = Instant.now();
        this.videoReferenceUuid = videoReferenceUuid;
        videoIndex.getElapsedTime().ifPresent(this::setElapsedTime);
        videoIndex.getTimestamp().ifPresent(this::setRecordedTimestamp);
        videoIndex.getTimecode().ifPresent(this::setTimecode);
    }

    public Annotation(Annotation a) {
        this.observationUuid = a.observationUuid;
        this.concept = a.concept;
        this.observer = a.observer;
        this.observationTimestamp = a.observationTimestamp;
        this.videoReferenceUuid = a.videoReferenceUuid;
        this.imagedMomentUuid = a.imagedMomentUuid;
        this.timecode = a.timecode;
        this.elapsedTime = a.elapsedTime;
        this.recordedTimestamp = a.recordedTimestamp;
        this.duration = a.duration;
        this.group = a.group;
        this.activity = a.activity;
        this.associations = a.associations == null ? new ArrayList<Association>() : a.associations.stream().map(Association::new).collect(Collectors.toList());
        this.imageReferences = a.imageReferences == null ? new ArrayList<ImageReference>() : a.imageReferences.stream().map(ImageReference::new).collect(Collectors.toList());
    }

    public UUID getObservationUuid() {
        return this.observationUuid;
    }

    public void setObservationUuid(UUID observationUuid) {
        this.observationUuid = observationUuid;
    }

    public String getConcept() {
        return this.concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public String getObserver() {
        return this.observer;
    }

    public void setObserver(String observer) {
        this.observer = observer;
    }

    public Instant getObservationTimestamp() {
        return this.observationTimestamp;
    }

    public void setObservationTimestamp(Instant observationTimestamp) {
        this.observationTimestamp = observationTimestamp;
    }

    @Override
    public UUID getVideoReferenceUuid() {
        return this.videoReferenceUuid;
    }

    @Override
    public void setVideoReferenceUuid(UUID videoReferenceUuid) {
        this.videoReferenceUuid = videoReferenceUuid;
    }

    @Override
    public UUID getImagedMomentUuid() {
        return this.imagedMomentUuid;
    }

    @Override
    public void setImagedMomentUuid(UUID imagedMomentUuid) {
        this.imagedMomentUuid = imagedMomentUuid;
    }

    @Override
    public Timecode getTimecode() {
        return this.timecode;
    }

    @Override
    public void setTimecode(Timecode timecode) {
        this.timecode = timecode;
    }

    @Override
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public void setElapsedTime(Duration elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    @Override
    public Instant getRecordedTimestamp() {
        return this.recordedTimestamp;
    }

    @Override
    public void setRecordedTimestamp(Instant recordedTimestamp) {
        this.recordedTimestamp = recordedTimestamp;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public List<Association> getAssociations() {
        return this.associations == null ? new ArrayList() : this.associations;
    }

    public void setAssociations(List<Association> associations) {
        ArrayList ass = associations == null ? new ArrayList() : associations;
        this.associations = Collections.unmodifiableList(ass);
    }

    public List<ImageReference> getImages() {
        return this.imageReferences;
    }

    public void setImages(List<ImageReference> images) {
        this.imageReferences = images;
    }

    public List<ImageReference> getImageReferences() {
        return this.imageReferences;
    }

    public void setImageReferences(List<ImageReference> imageReferences) {
        this.imageReferences = imageReferences;
    }

    public AncillaryData getAncillaryData() {
        return this.ancillaryData;
    }

    public void setAncillaryData(AncillaryData ancillaryData) {
        this.ancillaryData = ancillaryData;
    }

    public Object getTransientKey() {
        return this.transientKey;
    }

    public void setTransientKey(Object transientKey) {
        this.transientKey = transientKey;
    }

    public boolean isSaved() {
        return this.observationUuid != null;
    }

    public String toString() {
        int a = this.associations == null ? 0 : this.associations.size();
        int b = this.imageReferences == null ? 0 : this.imageReferences.size();
        return "Annotation{observationUuid=" + String.valueOf(this.observationUuid) + ", concept='" + this.concept + "', elapsedTime=" + String.valueOf(this.elapsedTime) + ", numOfAssociations=" + a + ", numOfImages=" + b + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation that = (Annotation)o;
        if (this.observationUuid != null && that.observationUuid != null) {
            return this.observationUuid.equals(that.observationUuid);
        }
        return Objects.nonNull(this.transientKey) && Objects.nonNull(that.transientKey) && Objects.equals(this.transientKey, that.transientKey);
    }

    public int hashCode() {
        return this.observationUuid.hashCode();
    }

    public VideoIndex getVideoIndex() {
        return new VideoIndex(Optional.ofNullable(this.recordedTimestamp), Optional.ofNullable(this.elapsedTime), Optional.ofNullable(this.timecode));
    }
}

