/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.Subject;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;

public class SimpleVideoIO<S extends VideoState, E extends VideoError>
implements VideoIO<S, E> {
    private final String connectionID;
    private final Subject<VideoCommand<?>> commandSubject;
    private final Observable<E> errorObservable;
    private final Observable<S> stateObservable;
    private final Observable<VideoIndex> indexObservable;

    public SimpleVideoIO(String connectionID, Subject<VideoCommand<?>> commandSubject, Observable<S> stateObservable, Observable<E> errorObservable, Observable<VideoIndex> indexObservable) {
        this.connectionID = connectionID;
        this.commandSubject = commandSubject;
        this.errorObservable = errorObservable;
        this.stateObservable = stateObservable;
        this.indexObservable = indexObservable;
    }

    @Override
    public Subject<VideoCommand<?>> getCommandSubject() {
        return this.commandSubject;
    }

    @Override
    public Observable<E> getErrorObservable() {
        return this.errorObservable;
    }

    @Override
    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    @Override
    public Observable<S> getStateObservable() {
        return this.stateObservable;
    }

    @Override
    public void close() {
        this.commandSubject.onComplete();
    }

    @Override
    public <A extends VideoCommand<?>> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    @Override
    public String getConnectionID() {
        return this.connectionID;
    }
}

