/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import java.util.ArrayList;
import org.mbari.vcr4j.VideoState;

public class VideoStateAsString {
    private String string;

    public VideoStateAsString(VideoState s) {
        StringBuilder sb = new StringBuilder("{name:'VideoState',class:'").append(s.getClass().getName()).append("',status:[");
        ArrayList<String> states = new ArrayList<String>();
        if (s.isConnected()) {
            states.add("'connected'");
        }
        if (s.isCueingUp()) {
            states.add("'cueing up'");
        }
        if (s.isPlaying()) {
            states.add("'playing'");
        }
        if (s.isReverseDirection()) {
            states.add("'reverse direction'");
        }
        if (s.isRewinding()) {
            states.add("'rewinding'");
        }
        if (s.isShuttling()) {
            states.add("'shuttling'");
        }
        if (s.isStopped()) {
            states.add("'stopped'");
        }
        String status = String.join((CharSequence)",", states);
        sb.append(status).append("]}");
        this.string = sb.toString();
    }

    public String toString() {
        return this.string;
    }
}

