/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.time;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.regex.Pattern;

public class HMSF {
    private final int hour;
    private final int minute;
    private final int second;
    private final int frame;
    private String stringRepresentation;
    private static final NumberFormat FORMAT = new DecimalFormat(){
        {
            this.setMaximumFractionDigits(0);
            this.setMinimumIntegerDigits(2);
            this.setMaximumIntegerDigits(2);
        }
    };
    private static final Pattern REGEX = Pattern.compile("^\\d{2}:\\d{2}:\\d{2}:\\d{2}");

    public HMSF(int hour, int minute, int second, int frame) {
        this.checkArgs(hour, minute, second, frame);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.frame = frame;
    }

    private void checkArgs(int hour, int minute, int second, int frame) {
        if (hour < 0 || minute < 0 || second < 0 || frame < 0) {
            throw new IllegalArgumentException("All values must be positive.");
        }
        if (hour > 99) {
            throw new IllegalArgumentException("Hour can not be greater than 99");
        }
        if (minute > 59 || second > 59) {
            throw new IllegalArgumentException("Minutes and Seconds can not be greater than 59");
        }
    }

    public static Optional<HMSF> from(String timecode) {
        HMSF hmsf = null;
        if (REGEX.matcher(timecode).matches()) {
            try {
                int h = Integer.parseInt(timecode.substring(0, 2));
                int m = Integer.parseInt(timecode.substring(3, 5));
                int s = Integer.parseInt(timecode.substring(6, 8));
                int f = Integer.parseInt(timecode.substring(9, 11));
                hmsf = new HMSF(h, m, s, f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(hmsf);
    }

    public static HMSF from(double frames, double frameRate) {
        double f = frames;
        int hour = (int)Math.floor(f / 60.0 / 60.0 / frameRate);
        int minute = (int)Math.floor((f -= (double)hour * 60.0 * 60.0 * frameRate) / 60.0 / frameRate);
        int second = (int)Math.floor((f -= (double)minute * 60.0 * frameRate) / frameRate);
        int frame = (int)Math.floor(f - (double)second * frameRate);
        return new HMSF(hour, minute, second, frame);
    }

    public static HMSF zero() {
        return new HMSF(0, 0, 0, 0);
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = String.valueOf(FORMAT.format(this.hour)) + ':' + FORMAT.format(this.minute) + ':' + FORMAT.format(this.second) + ':' + FORMAT.format(this.frame);
        }
        return this.stringRepresentation;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }
}

