/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Timer;
import java.util.TimerTask;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.Decorator;

public class VCRSyncDecorator<S extends VideoState, E extends VideoError>
implements Decorator {
    private Timer timer = new Timer(String.valueOf(this.getClass().getSimpleName()) + "-" + System.currentTimeMillis(), true);
    private Disposable disposable;
    Observer<VideoCommand<?>> subscriber = new Observer<VideoCommand<?>>(){

        public void onComplete() {
            VCRSyncDecorator.this.timer.cancel();
        }

        public void onError(Throwable throwable) {
            VCRSyncDecorator.this.unsubscribe();
        }

        public void onNext(VideoCommand videoCommand) {
        }

        public void onSubscribe(Disposable disposable) {
            VCRSyncDecorator.this.disposable = disposable;
        }
    };

    public VCRSyncDecorator(VideoIO<S, E> io) {
        this(io, 1000L, 40L, 500L);
    }

    public VCRSyncDecorator(final VideoIO<S, E> io, long statusInterval, long timecodeInterval, long timestampInterval) {
        io.getCommandSubject().subscribe(this.subscriber);
        TimerTask statusTask = new TimerTask(){

            @Override
            public void run() {
                io.send(VideoCommands.REQUEST_STATUS);
            }
        };
        this.timer.schedule(statusTask, 0L, statusInterval);
        TimerTask timecodeTask = new TimerTask(){

            @Override
            public void run() {
                io.send(VideoCommands.REQUEST_TIMECODE);
            }
        };
        this.timer.schedule(timecodeTask, 0L, timecodeInterval);
        TimerTask timestampTask = new TimerTask(){

            @Override
            public void run() {
                io.send(VideoCommands.REQUEST_TIMESTAMP);
            }
        };
        this.timer.schedule(timestampTask, 0L, timestampInterval);
    }

    protected Timer getTimer() {
        return this.timer;
    }

    @Override
    public void unsubscribe() {
        this.timer.purge();
        this.timer.cancel();
        this.disposable.dispose();
    }
}

