/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.time;

public class MediaTime {
    private final long value;
    private final int timescale;
    private final double seconds;
    private final boolean rounded;
    private String stringRep;

    public MediaTime(long value, int timescale, boolean rounded) {
        this.timescale = timescale;
        this.value = value;
        this.seconds = (double)value / (double)timescale;
        this.rounded = rounded;
    }

    public MediaTime(long value, int timescale) {
        this(value, timescale, false);
    }

    public long getValue() {
        return this.value;
    }

    public int getTimescale() {
        return this.timescale;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public static MediaTime fromSeconds(double seconds, int timescale) {
        double value = seconds * (double)timescale;
        boolean rounded = value % 1.0 != 0.0;
        return new MediaTime(Math.round(value), timescale, rounded);
    }

    public String toString() {
        if (this.stringRep == null) {
            this.stringRep = "MediaTime{seconds=" + this.seconds + " (" + this.value + "/" + this.timescale + ")" + ", rounded=" + this.rounded + '}';
        }
        return this.stringRep;
    }
}

