/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.time;

import java.util.Optional;
import org.mbari.vcr4j.time.FrameRates;
import org.mbari.vcr4j.time.HMSF;

public class Timecode {
    public static final String EMPTY_TIMECODE_STRING = "--:--:--:--";
    private final String stringRepresentation;
    private final double frameRate;
    private final double frames;
    private final Optional<HMSF> hmsf;

    public Timecode(double frames, double frameRate) {
        this.frames = frames;
        this.frameRate = frameRate;
        this.hmsf = Optional.of(HMSF.from(frames, frameRate));
        this.stringRepresentation = this.hmsf.map(HMSF::toString).orElse(EMPTY_TIMECODE_STRING);
    }

    public Timecode(String timecode, double frameRate) {
        this.stringRepresentation = timecode;
        this.hmsf = HMSF.from(timecode);
        this.frames = this.hmsf.map(v -> this.toFrames((HMSF)v, frameRate)).orElse(Double.NaN);
        this.frameRate = frameRate;
    }

    public Timecode(String timecode) {
        this.stringRepresentation = timecode;
        this.hmsf = HMSF.from(timecode);
        this.frames = Double.NaN;
        this.frameRate = Double.NaN;
    }

    private double toFrames(HMSF hmsf, double frameRate) {
        int h = hmsf.getHour();
        int m = hmsf.getMinute();
        int s = hmsf.getSecond();
        int f = hmsf.getFrame();
        return (double)((h * 60 + m) * 60 + s) * frameRate + (double)f;
    }

    public boolean isValid() {
        return this.hmsf.isPresent();
    }

    public boolean isComplete() {
        return this.hmsf.isPresent() && !Double.isNaN(this.frames) && !Double.isNaN(this.frameRate);
    }

    public Optional<HMSF> getHMSF() {
        return this.hmsf;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public double getFrames() {
        return this.frames;
    }

    public double getSeconds() {
        return this.frames / this.frameRate;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public static Timecode zero() {
        return new Timecode(0.0, FrameRates.NTSC);
    }
}

