/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.decorators.VideoCommandAsString;
import org.mbari.vcr4j.decorators.VideoErrorAsString;
import org.mbari.vcr4j.decorators.VideoIndexAsString;
import org.mbari.vcr4j.decorators.VideoStateAsString;

public class LoggingDecorator<S extends VideoState, E extends VideoError>
implements Decorator {
    protected final System.Logger log = System.getLogger(this.getClass().getName());
    List<Disposable> disposables = new ArrayList<Disposable>();
    protected final Observer<E> errorSubscriber = new Observer<E>(){

        public void onComplete() {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "Error observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "An error occurred in the error observable", throwable);
        }

        public void onNext(E error) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, () -> "Received: " + String.valueOf(new VideoErrorAsString((VideoError)error)));
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };
    protected final Observer<VideoIndex> indexSubscriber = new Observer<VideoIndex>(){

        public void onComplete() {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "Index observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "An error occurred in the index observable", throwable);
        }

        public void onNext(VideoIndex index) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, () -> "Received: " + String.valueOf(new VideoIndexAsString(index)));
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };
    protected final Observer<S> stateSubscriber = new Observer<S>(){

        public void onComplete() {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "State observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "An error occurred in the state observable", throwable);
        }

        public void onNext(S state) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, () -> "Received: " + String.valueOf(new VideoStateAsString((VideoState)state)));
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };
    protected final Observer<VideoCommand> commandSubscriber = new Observer<VideoCommand>(){

        public void onComplete() {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "State observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "An error occurred in the state observable", throwable);
        }

        public void onNext(VideoCommand command) {
            LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, () -> "Sending: " + new VideoCommandAsString(command).toString());
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };

    public LoggingDecorator(VideoIO<S, E> io) {
        io.getCommandSubject().subscribe(this.commandSubscriber);
        io.getErrorObservable().subscribe(this.errorSubscriber);
        io.getStateObservable().subscribe(this.stateSubscriber);
        io.getIndexObservable().subscribe(this.indexSubscriber);
    }

    @Override
    public void unsubscribe() {
        this.disposables.forEach(Disposable::dispose);
    }
}

