/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Timer;
import java.util.TimerTask;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.Decorator;

public class VideoSyncDecorator<S extends VideoState, E extends VideoError>
implements Decorator {
    private Timer timer = new Timer(this.getClass().getSimpleName() + "-" + System.currentTimeMillis(), true);
    private Disposable disposable;
    Observer<VideoCommand<?>> observer = new Observer<VideoCommand<?>>(){

        public void onComplete() {
            VideoSyncDecorator.this.timer.cancel();
        }

        public void onError(Throwable throwable) {
            VideoSyncDecorator.this.unsubscribe();
        }

        public void onNext(VideoCommand videoCommand) {
        }

        public void onSubscribe(Disposable disposable) {
            VideoSyncDecorator.this.disposable = disposable;
        }
    };

    public VideoSyncDecorator(VideoIO<S, E> io) {
        this(io, 1000L, 333L);
    }

    public VideoSyncDecorator(final VideoIO<S, E> io, long statusInterval, long indexInterval) {
        io.getCommandSubject().subscribe(this.observer);
        TimerTask statusTask = new TimerTask(){

            @Override
            public void run() {
                io.send(VideoCommands.REQUEST_STATUS);
            }
        };
        this.timer.schedule(statusTask, 0L, statusInterval);
        TimerTask timecodeTask = new TimerTask(){

            @Override
            public void run() {
                io.send(VideoCommands.REQUEST_INDEX);
            }
        };
        this.timer.schedule(timecodeTask, 0L, indexInterval);
    }

    protected Timer getTimer() {
        return this.timer;
    }

    @Override
    public void unsubscribe() {
        this.timer.cancel();
        this.disposable.dispose();
    }
}

