/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.time;

import java.util.Optional;
import org.mbari.vcr4j.time.HMSF;
import org.mbari.vcr4j.time.MediaTime;
import org.mbari.vcr4j.time.Timecode;

public class Converters {
    public static Optional<MediaTime> toMediaTime(Timecode timecode) {
        MediaTime mt = null;
        try {
            if (timecode.isComplete()) {
                double estimatedFrames;
                double estimatedFrameRate = Math.round(timecode.getFrameRate());
                boolean rounded = estimatedFrameRate % 1.0 + (estimatedFrames = (double)Math.round(timecode.getFrames())) % 1.0 != 0.0;
                mt = new MediaTime((long)estimatedFrames, (int)estimatedFrameRate, rounded);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(mt);
    }

    public static Timecode toTimecode(MediaTime mediaTime) {
        double seconds = mediaTime.getSeconds();
        return new Timecode(seconds * 100.0, 100.0);
    }

    public static Timecode toTimecode(HMSF hmsf) {
        return new Timecode(hmsf.toString());
    }
}

