/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.util;

import java.util.Objects;
import org.mbari.vcr4j.util.Tuple;

public class Pair<A, B>
implements Tuple {
    private A a;
    private B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A getA() {
        return this.a;
    }

    public void setA(A a) {
        this.a = a;
    }

    public B getB() {
        return this.b;
    }

    public void setB(B b) {
        this.b = b;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public Object getValueAt(int i) {
        if (i < 0 && i >= this.size()) {
            throw new IllegalArgumentException("Index out of bounds, " + this.getClass().getSimpleName() + " has " + this.size() + " elements");
        }
        switch (i) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
        }
        return null;
    }

    @Override
    public Class getTypeAt(int i) {
        if (i < 0 && i >= this.size()) {
            throw new IllegalArgumentException("Index out of bounds, " + this.getClass().getSimpleName() + " has " + this.size() + " elements");
        }
        switch (i) {
            case 0: {
                return this.a.getClass();
            }
            case 1: {
                return this.b.getClass();
            }
        }
        return null;
    }

    public String toString() {
        return "{" + String.valueOf(this.a) + "," + String.valueOf(this.b) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return this.a.equals(pair.a) && this.b.equals(pair.b);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }
}

