/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.jserialcomm;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.decorators.VideoIndexAsString;
import org.mbari.vcr4j.examples.jserialcomm.VARSDemo01;
import org.mbari.vcr4j.jserialcomm.SerialCommVideoIO;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422StatusDecorator;
import org.mbari.vcr4j.rs422.decorators.UserbitsAsTimeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectDisconnectDemo01 {
    public static void main(String[] args) throws Exception {
        String prog = VARSDemo01.class.getName();
        String doc = "Usage: " + prog + " <commport> [options]\n\nOptions:\n  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        String portName = (String)opts.get("<commport>");
        ConnectDisconnectDemo01.run(portName);
        ConnectDisconnectDemo01.run(portName);
    }

    private static void run(String serialPort) throws Exception {
        Logger log = LoggerFactory.getLogger(ConnectDisconnectDemo01.class);
        SerialCommVideoIO io = SerialCommVideoIO.open((String)serialPort);
        VCRSyncDecorator syncDecorator = new VCRSyncDecorator((VideoIO)io);
        RS422StatusDecorator statusDecorator = new RS422StatusDecorator((VCRVideoIO)io);
        UserbitsAsTimeDecorator timeDecorator = new UserbitsAsTimeDecorator((VCRVideoIO)io);
        timeDecorator.getIndexObservable().subscribe(vi -> log.debug("USERBITS: " + new VideoIndexAsString(vi).toString()));
        AtomicBoolean wait = new AtomicBoolean(true);
        Disposable disposable0 = io.getStateObservable().subscribeOn(Schedulers.io()).filter(RS422State::isPlaying).take(1L).forEach(state -> {
            log.info("THE DEVICE IS PLAYING");
            wait.set(false);
        });
        io.send((VideoCommand)VideoCommands.PLAY);
        while (wait.get()) {
            Thread.sleep(200L);
        }
        disposable0.dispose();
        log.info("DEVICE IS IN PLAY MODE. REQUESTING TIME AT 1 SEC INTERVALS");
        for (int i = 0; i < 5; ++i) {
            io.send((VideoCommand)VideoCommands.REQUEST_TIMESTAMP);
            Thread.sleep(1000L);
        }
        io.getStateObservable().filter(RS422State::isStopped).take(1L).forEach(state -> {
            io.close();
            wait.set(false);
        });
        wait.set(true);
        log.info("STOPPING DEVICE");
        io.send((VideoCommand)VideoCommands.STOP);
        while (wait.get()) {
            Thread.sleep(200L);
        }
    }
}

