/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.jserialcomm;

import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.SeekTimecodeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.VideoCommandAsString;
import org.mbari.vcr4j.decorators.VideoIndexAsString;
import org.mbari.vcr4j.decorators.VideoStateAsString;
import org.mbari.vcr4j.jserialcomm.SerialCommVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422ErrorAsString;
import org.mbari.vcr4j.rs422.util.NumberUtilities;
import org.mbari.vcr4j.time.FrameRates;
import org.mbari.vcr4j.time.Timecode;

public class ShuttleDemo01 {
    private PrintStream stream;
    private SerialCommVideoIO io;

    public ShuttleDemo01(SerialCommVideoIO io, PrintStream stream) {
        this.stream = stream;
        this.io = io;
        io.getIndexObservable().subscribe(index -> stream.print(new VideoIndexAsString(index).toString() + "\n"));
        io.getStateObservable().subscribe(state -> stream.print(new VideoStateAsString((VideoState)state).toString() + "\n"));
        io.getCommandSubject().subscribe(videoCommand -> stream.print(new VideoCommandAsString(videoCommand) + "\n"));
        io.getErrorObservable().distinctUntilChanged().subscribe(error -> stream.print(new RS422ErrorAsString(error) + "\n"));
        io.getTimecodeObservable().subscribe(timecode -> stream.print("{timecode:'" + timecode + "'}\n"));
        io.getUserbitsObservable().subscribe(userbits -> stream.print("{userbits: 0x" + NumberUtilities.toHexString((byte[])userbits.getUserbits()) + "}\n"));
    }

    public void apply(int n) {
        double rate;
        int i;
        this.io.send((VideoCommand)VideoCommands.PLAY);
        this.requestStatusAndWait(n * 500);
        for (i = 1; i <= n; ++i) {
            rate = 1.0 - 1.0 / (double)i;
            this.io.send((VideoCommand)new ShuttleCmd(rate));
            this.requestStatusAndWait(3000L * (long)rate);
        }
        for (i = 1; i <= n; ++i) {
            rate = -(1.0 - 1.0 / (double)i);
            this.io.send((VideoCommand)new ShuttleCmd(rate));
            this.requestStatusAndWait(3000L * (long)rate);
        }
        for (i = 0; i < n; ++i) {
            this.io.getTimecodeObservable().take(1L).forEach(tc -> {
                Timecode currentTC = new Timecode(tc.getTimecode().toString(), FrameRates.NTSC);
                Timecode nextTC = new Timecode(currentTC.getFrames() + FrameRates.NTSC * 3.0, FrameRates.NTSC);
                this.io.send((VideoCommand)new SeekTimecodeCmd(nextTC));
                this.io.getStateObservable().takeWhile(state -> !state.isStopped()).subscribe(state -> this.requestStatusAndWait(200L));
            });
            this.io.send((VideoCommand)VideoCommands.REQUEST_TIMECODE);
        }
        this.io.send((VideoCommand)VideoCommands.STOP);
    }

    private void requestStatusAndWait(long wait) {
        try {
            this.io.send((VideoCommand)VideoCommands.REQUEST_STATUS);
            Thread.sleep(wait);
        }
        catch (Exception e) {
            this.stream.print("Thread got interrupted: " + e);
        }
    }

    public static void main(String[] args) {
        PrintStream stream;
        String prog = ShuttleDemo01.class.getName();
        String doc = "Usage: " + prog + " <commport> [options]\n\nOptions:\n  -h, --help\n  -l LOG_FILE, --logfile LOG_FILE A file to log output to\n  -n NUM_ITER, --number-iterations NUM_ITER  Number of iterations for each stage [default: 5]\n";
        Map opts = new Docopt(doc).parse(args);
        String portName = (String)opts.get("<commport>");
        int numIter = Integer.parseInt((String)opts.get("--number-iterations"));
        try {
            String logfile = (String)opts.get("--logfile");
            stream = new PrintStream(new File(logfile));
        }
        catch (Exception e) {
            stream = System.out;
        }
        SerialCommVideoIO io = SerialCommVideoIO.open((String)portName);
        ShuttleDemo01 demo = new ShuttleDemo01(io, stream);
        demo.apply(numIter);
        io.close();
    }
}

