/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.FrameCaptureCmd;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.PlayCmd;
import org.mbari.vcr4j.remote.control.commands.RemoteCommands;

public class AllCmdsDemo01 {
    public static void main(String[] args) throws Exception {
        String prog = AllCmdsDemo01.class.getName();
        String doc = "Usage: " + prog + " <port> <url>\nOptions:\n  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        int port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        UUID uuid = UUID.randomUUID();
        List<VideoCommand> commands = List.of(new OpenCmd(uuid, url), VideoCommands.PLAY, VideoCommands.FAST_FORWARD, VideoCommands.REWIND, VideoCommands.PAUSE, VideoCommands.PLAY, VideoCommands.REQUEST_ELAPSED_TIME, VideoCommands.REQUEST_INDEX, VideoCommands.REQUEST_STATUS, VideoCommands.REQUEST_DEVICE_TYPE, VideoCommands.REQUEST_TIMECODE, VideoCommands.REQUEST_TIMESTAMP, RemoteCommands.FRAMEADVANCE, RemoteCommands.REQUEST_ALL_VIDEO_INFOS, RemoteCommands.REQUEST_VIDEO_INFO, RemoteCommands.SHOW, new PlayCmd(uuid, Double.valueOf(-2.0)), new PlayCmd(uuid, Double.valueOf(-2.0)), new ShuttleCmd(0.02), new ShuttleCmd(-0.02), new SeekElapsedTimeCmd(Duration.ofMillis(1000L)), new PlayCmd(uuid, Double.valueOf(0.01)), new SeekElapsedTimeCmd(Duration.ofMillis(50000L)), new PlayCmd(uuid, Double.valueOf(0.01)), new FrameCaptureCmd(uuid, UUID.randomUUID(), new File("trashme-" + UUID.randomUUID() + ".png").getAbsolutePath()), new SeekElapsedTimeCmd(Duration.ofMillis(10000L)), new PlayCmd(uuid, Double.valueOf(0.01)), new OpenCmd(uuid, url), RemoteCommands.CLOSE);
        List<Integer> ports = List.of(Integer.valueOf(5000));
        for (Integer listenPort : ports) {
            RemoteControl io = (RemoteControl)new RemoteControl.Builder(uuid).port(listenPort.intValue()).remotePort(port).remoteHost("localhost").build().get();
            Thread.sleep(1000L);
            for (VideoCommand cmd : commands) {
                io.getVideoIO().send(cmd);
                Thread.sleep(1000L);
            }
            Thread.sleep(1000L);
            io.close();
        }
        System.exit(0);
    }
}

