/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.examples.remote.SimpleDemo01;
import org.mbari.vcr4j.remote.control.RError;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;

public class BasicTest01 {
    private static Logger log = LoggerFactory.getLogger(BasicTest01.class);

    public static void main(String[] args) throws Exception {
        String prog = SimpleDemo01.class.getName();
        String doc = "Usage: %s <port> <url>\nOptions:\n  -h, --help\n".formatted(prog);
        Map opts = new Docopt(doc).parse(args);
        int port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        UUID uuid = UUID.randomUUID();
        List<OpenCmd> commands = List.of(new OpenCmd(uuid, url));
        try (RVideoIO io = new RVideoIO(uuid, "localhost", port);){
            io.getErrorObservable().subscribe(BasicTest01::logError);
        }
    }

    private static <A extends RError> void logError(A error) {
        LoggingEventBuilder m = log.atError();
        if (error.getException().isPresent()) {
            m = m.setCause((Throwable)error.getException().get());
        }
    }
}

