/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.RemoteCommands;
import org.mbari.vcr4j.remote.control.commands.VideoInfo;
import org.mbari.vcr4j.remote.control.commands.localization.AddLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.Localization;

public class Issue15 {
    public static void main(String[] args) throws Exception {
        AppArgs appArgs = AppArgs.parse(args, Issue15.class.getName());
        RemoteControl rc = appArgs.remoteControl();
        UUID uuid = appArgs.getVideoUuid();
        URL url = appArgs.url();
        RVideoIO io = rc.getVideoIO();
        io.getVideoInfoObservable().subscribe(xs -> {
            if (xs.size() == 1) {
                VideoInfo head = (VideoInfo)xs.get(0);
                List<Localization> locs = AppArgs.buildLocalizations(10000, head.getDurationMillis(), 1280, 720);
                AddLocalizationsCmd cmd = new AddLocalizationsCmd(uuid, locs);
                io.send((VideoCommand)cmd);
            }
        });
        io.send((VideoCommand)new OpenCmd(uuid, url));
        Thread.sleep(2000L);
        io.send((VideoCommand)RemoteCommands.REQUEST_VIDEO_INFO);
    }
}

