/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.FrameCaptureCmd;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;

public class FrameCaptureDemo01 {
    public static void main(String[] args) throws Exception {
        String prog = FrameCaptureDemo01.class.getName();
        String doc = "Usage: " + prog + " <port> <url>\nOptions:\n  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        Integer port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        UUID uuid = UUID.randomUUID();
        RemoteControl io = (RemoteControl)new RemoteControl.Builder(uuid).port(5000).remotePort(port.intValue()).remoteHost("localhost").whenFrameCaptureIsDone(cmd -> System.out.println(cmd)).build().get();
        RVideoIO videoIo = io.getVideoIO();
        File png = new File("trashme.png");
        File png2 = new File("trashme2.png");
        videoIo.send((VideoCommand)new OpenCmd(uuid, url));
        videoIo.send((VideoCommand)VideoCommands.PLAY);
        Thread.sleep(500L);
        videoIo.send((VideoCommand)new SeekElapsedTimeCmd(Duration.ofMillis(10000L)));
        videoIo.send((VideoCommand)VideoCommands.REQUEST_INDEX);
        videoIo.send((VideoCommand)VideoCommands.PLAY);
        Thread.sleep(1000L);
        videoIo.send((VideoCommand)VideoCommands.REQUEST_INDEX);
        videoIo.send((VideoCommand)new FrameCaptureCmd(uuid, UUID.randomUUID(), png.getAbsolutePath()));
        Thread.sleep(1000L);
        videoIo.send((VideoCommand)new SeekElapsedTimeCmd(Duration.ofMillis(400000L)));
        videoIo.send((VideoCommand)VideoCommands.REQUEST_INDEX);
        videoIo.send((VideoCommand)VideoCommands.PLAY);
        videoIo.send((VideoCommand)new FrameCaptureCmd(uuid, UUID.randomUUID(), png2.getAbsolutePath()));
        Thread.sleep(1000L);
        io.close();
        System.exit(0);
    }
}

